% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tau.R
\name{get_tau}
\alias{get_tau}
\title{Obtain difficulty parameters from item bank}
\usage{
get_tau(
  items,
  key = NULL,
  itembank = dscore::builtin_itembank,
  verbose = FALSE
)
}
\arguments{
\item{items}{A character vector containing names of items to be
included into the D-score calculation. Milestone scores are coded
numerically as \code{1} (pass) and \code{0} (fail). By default,
D-score calculation is done on all items found in the data
that have a difficulty parameter under the specified \code{key}.}

\item{key}{String. They key identifies 1) the difficulty estimates
pertaining to a particular Rasch model, and 2) the prior mean and standard
deviation of the prior distribution for calculating the D-score.
The default key \code{NULL} sets \code{key = "gsed2406"}.
View \code{builtin_keys} for an overview of the available keys.}

\item{itembank}{A \code{data.frame} with at least three columns named
\code{key}, \code{item} and \code{tau}. By default, the function uses
\code{dscore::builtin_itembank}. If you specify your own \code{itembank},
then you should also provide the relevant \code{transform} and \code{qp} arguments.}

\item{verbose}{Logical. Print settings.}
}
\value{
A named vector with the difficulty estimate per item with
\code{length(items)} elements.
}
\description{
Searches the item bank for matching items, and returns the
difficulty estimates. Matching is done by item name. Comparisons
are done in lower case.
}
\examples{
# difficulty levels in the GHAP lexicon
get_tau(items = c("ddifmd001", "DDigmd052", "xyz"))
}
\seealso{
\code{\link[=builtin_itembank]{builtin_itembank()}}, \code{\link[=dscore]{dscore()}}
}
\author{
Stef van Buuren 2020
}
