% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodmap.R
\name{goodmap}
\alias{goodmap}
\title{The \code{goodmap} function is designed to create interactive PNG Map or GIF Map from a provided data file.
It supports two types of maps: \code{point} and \code{polygon}.
The function can visualize data by either plotting points based on geographical coordinates
or highlighting regions polygon based on their administrative boundaries (province or city level).
Additionally, the function can generate animated that showcase the change of data.}
\usage{
goodmap(
  data_file,
  type = "point",
  level = NULL,
  animate = FALSE,
  animate_var = NULL,
  map_center = c(35.8617, 104.1954),
  zoom_level = 4,
  color_type = "numeric",
  custom_colors = NULL,
  point_radius = 5,
  legend_opacity = 0.7,
  legend_name = NULL,
  width = 800,
  height = 900
)
}
\arguments{
\item{data_file}{Dataframe.
When generate point map, \code{data_file} should include required columns such as \code{g_lat} and \code{g_lon}.
When generate polygon map, \code{data_file} should include required columns such as \code{prov} or \code{city}.
The \code{prov} columns must be complete, official names rather than any shortened form or abbreviation.
If there is only incomplete names or geocodes in your data_file, we recommend you to use function \code{regioncode}
as a one-step solution to these conversion from incomplete names.
Ensure the file is formatted correctly with appropriate column headers.}

\item{type}{A string specifying the type of map to generate. Options are \code{point}for point maps using \code{g_lat} and \code{g_lon},
or \code{polygon} for maps with administrative boundaries.}

\item{level}{A string specifying the level of administrative boundaries for polygon maps.
Acceptable values are \code{province} or \code{city}. This parameter is required if \code{type} is \code{polygon}.}

\item{animate}{A logical value indicating whether to generate an animation from the maps. The default is FALSE.
If animate is FALSE, the whole data will be generated as a PNG file.
If animate is TRUE, an animation will be generated from all panel data, the animate_var must be assigned.}

\item{animate_var}{A string specifying the variable to animate over.
The default is \code{NULL}, the whole data will be generated as a PNG file.
If an animation is needed, \code{data_file} should include required the \code{animate_set} column.
\code{animate_set} includes a series of unique values that represents year or month, or other categorical variable.
The frame number of the animation depends on the \code{animate_set}.}

\item{map_center}{A numeric vector of length 2 specifying the latitude and longitude
for the center of the map view. Default is \code{c(35.8617, 104.1954)}, which
is approximately the center of China.}

\item{zoom_level}{A numeric value specifying the zoom level for the map. Default is 3.}

\item{color_type}{If the data is discrete, such as types or categories, choose \code{factor}.
If the data is continuous, such as temperature or pressure, choose \code{numeric}. Default is numeric.}

\item{custom_colors}{A vector of colors for customizing the color gradient. Default is \code{NULL},
which uses the predefined color palette.}

\item{point_radius}{A numeric value specifying the radius for point markers on point maps. Default is 5.}

\item{legend_opacity}{A numeric value specifying the opacity of the legend. Default is 0.7.}

\item{legend_name}{The name of the legend. Default is \code{Value}.}

\item{width}{A numeric value specifying the width of the map images. Default is 800.}

\item{height}{A numeric value specifying the height of the map images. Default is 900.}
}
\value{
Image in the viewer.
}
\description{
If the map type is \code{point}, the color and size of the points will be determined by the
\code{value_set} column in the data file, which means the different value of each point.
If the map type is \code{polygon}, the color of the polygons will be determined by the average
value of the \code{value_set} column for each city or province in the data file.
}
\examples{

\dontrun{
goodmap(
   toy_poly,
   type = "polygon",
   level = "province"
)
}

}
