% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{dose_thresh_attributable_one_sided}
\alias{dose_thresh_attributable_one_sided}
\title{Inference for threshold attributable effects in sensitivity analysis with
continuous exposures and binary outcomes. Gurobi must be installed to use
this function.}
\usage{
dose_thresh_attributable_one_sided(
  Z,
  Q,
  index,
  gamma,
  alpha = 0.05,
  monotone = TRUE,
  Delta,
  sign = "positive",
  direction = "equal",
  threshold = 0,
  M = 10000,
  eps = 0.01,
  mv_threshold = NA,
  baseline = 0,
  relax = FALSE,
  feasible = TRUE,
  MIPgap = 0.01,
  WorkLimit = 1000,
  OutputFlag = 0
)
}
\arguments{
\item{Z}{A length N vector of (nonnegative) observed doses.}

\item{Q}{A length N vector of observed binary outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{alpha}{Level of the test.}

\item{monotone}{Whether to impose a monotonicity constraint on
the potential outcomes}

\item{Delta}{A numeric for the attributable effect to be tested for.}

\item{sign}{The sign of monotonicity - "positive" or "negative".}

\item{direction}{A string indicating the direction of testing the attributable
effect with respect to Delta; "greater", "equal", or "less"}

\item{threshold}{The threshold for the TAE.}

\item{M}{The numeric penalty parameter to ensure correct sign relationship.}

\item{eps}{precision parameter for the objective function if solving feasible
= "Yes"}

\item{mv_threshold}{The number of allowed monotonicity violations.}

\item{baseline}{The baseline dose level for defining the threshold attributable
effect.}

\item{relax}{Whether to solve the continuous relaxation.}

\item{feasible}{Whether to look for a feasible solution or to find the optima.}

\item{MIPgap}{Gurobi parameter specifying the precision of the mixed integer
program solution; default is 0.01.}

\item{WorkLimit}{Gurobi parameter specifying the maximum work units before
stopping; default is 1000.}

\item{OutputFlag}{0 if Gurobi print output is desired, 1 otherwise; default 0.}
}
\value{
A list containing the following:

\item{sol}{A gurobi object containing the solution to the optimization. If
feasible is TRUE, then failing to find a solution indiciates rejection. If
feasible is FALSE, then optimal value greater than zero indiciates rejection.}
\item{attribut}{The attributable effect attained by the least rejectable
allocation of potential outcomes and unmeasured confounders.}
\item{search}{A list of length the number of matched sets containing the
matrix of compatible baseline potential outcomes in each matched set.}
\item{null_exp}{The null expectation of the pivot attained by the least
rejectable allocation of potential outcomes and unmeasured confounders.}
\item{obsT}{The value of the pivot attained by the least rejectable
allocation of potential outcomes and unmeasured confounders.}
\item{nps}{A vector with length the number of matched sets containing the
size of each matched set.}
\item{start.ind}{A vector with length the number of matched sets containing
the starting index of the decision
variables pertaining to each matched set in the optimization program.}
\item{exp_upper}{The expectation of the pivot attained by the unmeasured
confounders equalling the baseline potential outcome.}
\item{var_upper}{The variance of the pivot attained by the unmeasured
confounders equalling the baseline potential outcome.}
\item{dose}{A list of length the number of matched sets containing the
vector of doses observed in each matched set.}
\item{model}{The initialized gurobi model.}
}
\description{
Inference for threshold attributable effects in sensitivity analysis with
continuous exposures and binary outcomes. Gurobi must be installed to use
this function.
}
\examples{
# To run the following example, Gurobi must be installed.
# Load the data
data <- lead_crime
# Solve the mixed-integer program.

solution = tryCatch(dose_thresh_attributable_one_sided(data$log_lead,
data$complain, data$matched_sets,
gamma=log(1), alpha = 0.1, monotone = TRUE, Delta = 5,
 direction = "less", threshold = log(3.5),M = 10000,
 eps = 0.0001,relax = FALSE, feasible = FALSE),
    error = function(e) NULL
 )


}
