% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-dm.R
\name{dm_draw}
\alias{dm_draw}
\title{Draw a diagram of the data model}
\usage{
dm_draw(
  dm,
  rankdir = "LR",
  ...,
  col_attr = NULL,
  view_type = c("keys_only", "all", "title_only"),
  column_types = NULL,
  backend = c("DiagrammeR"),
  backend_opts = list(),
  columnArrows = lifecycle::deprecated(),
  graph_attrs = lifecycle::deprecated(),
  node_attrs = lifecycle::deprecated(),
  edge_attrs = lifecycle::deprecated(),
  focus = lifecycle::deprecated(),
  graph_name = lifecycle::deprecated(),
  font_size = lifecycle::deprecated()
)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{rankdir}{Graph attribute for direction (e.g., 'BT' = bottom --> top).}

\item{...}{These dots are for future extensions and must be empty.}

\item{col_attr}{Deprecated, use \code{colummn_types} instead.}

\item{view_type}{Can be "keys_only" (default), "all" or "title_only".
It defines the level of details for rendering tables
(only primary and foreign keys, all columns, or no columns).}

\item{column_types}{Set to \code{TRUE} to show column types.}

\item{backend}{Currently, only the default \code{"DiagrammeR"} is accepted.
Pass this value explicitly if your code relies on the type of the return value.}

\item{backend_opts}{A named list of backend-specific options.
For the \code{"DiagrammeR"} backend, supported options are:
\itemize{
\item \code{graph_attrs}: Additional graph attributes (default \code{""}).
\item \code{node_attrs}: Additional node attributes (default \code{""}).
\item \code{edge_attrs}: Additional edge attributes (default \code{""}).
\item \code{focus}: A list of parameters for rendering (table filter).
\item \code{graph_name}: The name of the graph (default \code{"Data Model"}).
\item \code{column_arrow}: Edges from columns to columns (default \code{TRUE}).
\item \code{font_size}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Font size for \code{header} (default \code{16}), \code{column} (default \code{16}),
and \code{table_description} (default \code{8}).
Can be set as a named integer vector, e.g.
\code{c(table_headers = 18L, table_description = 6L)}.
}}

\item{columnArrows}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(column_arrow = ...)} instead.}

\item{graph_attrs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(graph_attrs = ...)} instead.}

\item{node_attrs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(node_attrs = ...)} instead.}

\item{edge_attrs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(edge_attrs = ...)} instead.}

\item{focus}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(focus = ...)} instead.}

\item{graph_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(graph_name = ...)} instead.}

\item{font_size}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use
\code{backend_opts = list(font_size = ...)} instead.}
}
\value{
An object with a \code{\link[=print]{print()}} method, which,
when printed, produces the output seen in the viewer as a side effect.
Currently, this is an object of class \code{grViz} (see also
\code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}), but this is subject to change.
}
\description{
\code{dm_draw()} draws a diagram, a visual representation of the data model.
}
\details{
Currently, \pkg{dm} uses \pkg{DiagrammeR} to draw diagrams.
Use \code{\link[DiagrammeRsvg:export_svg]{DiagrammeRsvg::export_svg()}} to convert the diagram to an SVG file.

The backend for drawing the diagrams might change in the future.
If you rely on DiagrammeR, pass an explicit value for the \code{backend} argument.
}
\examples{
\dontshow{if (rlang::is_installed(c("nycflights13", "DiagrammeR"))) withAutoprint(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_draw()

dm_nycflights13(cycle = TRUE) \%>\%
  dm_draw(view_type = "title_only")

head(dm_get_available_colors())
length(dm_get_available_colors())

dm_nycflights13() \%>\%
  dm_get_colors()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dm_set_colors]{dm_set_colors()}} for defining the table colors.

\code{\link[=dm_set_table_description]{dm_set_table_description()}} for adding details to one or more tables in the diagram
}
