% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDescTbl.R
\name{plotDescTbl}
\alias{plotDescTbl}
\title{Variable Visualizations for Descriptive Tables}
\usage{
plotDescTbl(
  dtab,
  plotfuns = NULL,
  verbose = 0,
  pairwise.display = "none",
  pval.display = FALSE,
  ...
)
}
\arguments{
\item{dtab}{\code{data.frame} with attributes
\code{descrtbl_full}, \code{data}, and \code{groupby} as
generated by \code{\link[descsuppR]{buildDescrTbl}}}

\item{plotfuns}{named list of tibbles.  names must be in \code{dtab$parameter}.  entries must be of the form \code{tibble(plotfun = "betweenstats", args = list(list(messages = FALSE, type = "nonparametric")))}.  For missing entries \code{plotDescTbl} tries to guess a suitable plot function.  Defaults to \code{NULL} meaning that the plot functions for all parameters are guessed.}

\item{verbose}{logical or integer.  Level of verbosity.  If
\code{TRUE} or > 0, print some messages.  Defaults to 0.}

\item{pairwise.display}{Decides if and which pairwise comparisons are shown in the plots.
Available options are:
- `"none"`
- `"significant"` (abbreviation accepted: `"s"`)
- `"non-significant"` (abbreviation accepted: `"ns"`)
- `"all"`
Defaults to "none".}

\item{pval.display}{logical.  If \code{TRUE} p-values are shown in the plots.
If \code{dtab} contains adjusted p-values, these are shown in the plots. Defaults to
  \code{FALSE}.}

\item{...}{additional parameters will be passed to the plotting functions.}
}
\value{
\code{tibble} with column \code{p} containing the plots.
}
\description{
Using as underlying functions the plot functions from
\code{ggstatsplot} this package visualizes the variables in a
descriptive table generated via
\code{\link[descsuppR]{buildDescrTbl}}.
}
\examples{
ttt <- data.frame(data="training set",
                  age=runif(100, 0, 100),
                  sex=as.factor(sample(c("m","f"), 100, replace=TRUE, prob=c(0.3, 0.7))),
                  score=factor(sample(1:5, 100, replace=TRUE),
                    ordered=TRUE,
                    levels=1:5))
ttt2 <- data.frame(data="test set",
                   age=runif(100, 0, 100),
                   sex=as.factor(sample(c("m","f"), 100, replace=TRUE, prob=c(0.5,0.5))),
                   score=factor(sample(1:5, 100, replace=TRUE),
                     ordered=TRUE,
                     levels=1:5))

## ungrouped table and plots
dtab <- buildDescrTbl(dplyr::mutate(rbind(ttt, ttt2), data = as.factor(data)),
                      includeNAs=TRUE,
                      dopvals = TRUE)

plotDescTbl(dtab)

## grouped table and plots
dtab <- buildDescrTbl(dplyr::mutate(rbind(ttt, ttt2), data = as.factor(data)),
                      groupby="data",
                      includeNAs=TRUE,
                      dopvals = TRUE)

plotDescTbl(dtab)
}
\author{
Dr. Andreas Leha
}
