% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.ob_decompose}
\alias{summary.ob_decompose}
\title{summary method for class "ob_decompose"}
\usage{
\method{summary}{ob_decompose}(
  object,
  ...,
  aggregate_factors = TRUE,
  custom_aggregation = NULL,
  confidence_level = 0.95
)
}
\arguments{
\item{object}{an object of class "ob_decompose", usually , a result of a call to [ob_decompose()].}

\item{...}{other parameters to be passed through to summary function.}

\item{aggregate_factors}{boolean, if `TRUE` (default) terms associated with detailed factor
levels are aggregated to a single term for every factor variable.}

\item{custom_aggregation}{list specifying the aggregation of detailed decomposition
terms. The parameter `custom_aggregation` overrides the parameter `aggregate_factors`.
If `NULL` (default), then either all detailed terms or all terms associated with
a single variable are returned.}

\item{confidence_level}{numeric value between 0 and 1 (default = 0.95) that defines the printed confidence interval.}
}
\value{
The function \code{summary.ob_decompose()} summarizes the decompositions terms saved in \code{object}.
}
\description{
Apart from displaying the (detailed) decomposition results with standard
errors, \code{summary.ob_decompose()} allows to customize the aggregation of the
detailed decomposition terms.
}
\examples{
data("nlys00")
mod1 <- log(wage) ~ age + education + years_worked_civilian +
  years_worked_military + part_time + industry

decompose_results <- ob_decompose(
  formula = mod1,
  data = nlys00,
  group = female,
  reference_0 = TRUE
)

# Print standard errors
summary(decompose_results)

# Aggregate decomposition terms associated with factor levels
summary(decompose_results, aggregate_factors = TRUE)

# custom aggregation of decomposition terms
custom_aggregation <-
  list(
    `Age` = c("age"),
    `Education` = c(
      "education<10 yrs",
      "educationHS grad (diploma)",
      "educationHS grad (GED)",
      "educationSome college",
      "educationBA or equiv. degree",
      "educationMA or equiv. degree",
      "educationPh.D or prof. degree"
    ),
    `Life-time work experience` = c(
      "years_worked_civilian",
      "years_worked_military",
      "part_time"
    ),
    `Industrial sectors` = c(
      "industryManufacturing",
      "industryEducation, Health, Public Admin.",
      "industryOther services"
    )
  )
summary(decompose_results, custom_aggregation = custom_aggregation)

}
