% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nlys00}
\alias{nlys00}
\title{Sample of NLSY79 wage data from 2000}
\format{
A data frame with 5,396 rows and 15 variables.
\describe{
  \item{female}{Female indicator}
  \item{wage}{Hourly wage in US dollars}
  \item{age}{Age in years}
  \item{central_city}{Central city indicator}
  \item{msa}{Metropolitan statistical area (MSA) indicator}
  \item{region}{Factor variable disinguishing 4 large regions}
  \item{black}{Black indicator}
  \item{hispanic}{Hispanic indicator}
  \item{education}{Factor variable indicating highest attained education}
  \item{afqt}{Percentile score of armed force qualification test (AFTQ) devided by 10}
  \item{family_responsibility}{Family responsibility indicator}
  \item{years_worked_civilian}{Years worked in cilivian labor force}
  \item{years_worked_military}{Years worked in military}
  \item{part_time}{Share of years worked in part-time}
  \item{industry}{Factor variable identifying 4 industries}
}
}
\source{
Fortin, Nicole M., Thomas Lemieux, and Firpo Segio. 2011.
"Decomposition Methods in Economics." In Orley Ashenfelter and David Card, eds.,
Handbook of Labor Economics, Volume 4a., Chapter 1, 1-102.
}
\usage{
nlys00
}
\description{
Sample of National Longitudinal Survey (NLSY) 79
 containig wage data from the year 2000
of workers who were aged 35 to 43 in that year. The data is from O'Neill
and O'Neill (2006) and is used as an illustration of the Oxaca-Blinder mean
decomposition in Firpo, Fortin, and Lemieuex (2011). The data contains 2655
male and 2654 female observations, respectively.
}
\keyword{datasets}
