% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GU_normalization.R
\name{GU_normalization}
\alias{GU_normalization}
\title{Gardeazabal and Ugidos normalization of factor variables}
\usage{
GU_normalization(formula, data, weights, group)
}
\arguments{
\item{formula}{an object of class "formula". See \link[stats]{lm} for further details.}

\item{data}{a data frame containing the variables in the model.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.}

\item{group}{name of the a binary variable (numeric or factor) identifying the two groups that will be compared.}
}
\value{
a list containing the adjusted formula, adjusted data, adjusted coefficient names,
and the normalized regressors for prediction and the
}
\description{
The function performs the normalization of the factor variables
proposed by Gardeazabal and Ugidos (2004, GU) to estimate detailed decompositions
that do not depend on the chosen reference levels of the factor variables.
}
\examples{
data("men8305")
mod1 <- log(wage) ~ union + married + nonwhite + education + experience
normalized_data <- GU_normalization(
  formula = mod1,
  data = men8305,
  weights = weights,
  group = year
)

}
\references{
Gardeazabal, Javier, and Arantza Ugidos. 2004. "More on identification in detailed wage decompositions."
\emph{Review of Economics and Statistics} 86(4): 1034-1036.
}
