% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{predicted.musicians}
\alias{predicted.musicians}
\title{Predicted musician groups}
\format{
A \code{data.frame} with \code{540} rows and \code{10} variables:
\describe{
  \item{Classifier}{The applied classifier.
  One of \code{"nnet_multinom"}, \code{"randomForest"}, and \code{"e1071_svm"}.}
  \item{Fold Column}{The fold column name. Each is a unique 5-fold split.
  One of \code{".folds_1"}, \code{".folds_2"}, and \code{".folds_3"}.}
  \item{Fold}{The fold. \code{1} to \code{5}.}
  \item{ID}{Musician identifier, 60 levels}
  \item{Target}{The actual class of the musician.
  One of \code{"A"}, \code{"B"}, \code{"C"}, and \code{"D"}.}
  \item{A}{The probability of class \code{"A"}.}
  \item{B}{The probability of class \code{"B"}.}
  \item{C}{The probability of class \code{"C"}.}
  \item{D}{The probability of class \code{"D"}.}
  \item{Predicted Class}{The predicted class. The argmax of the four probability columns.}
}
}
\description{
Predictions by 3 classifiers of the 4 classes in the
\code{\link[cvms:musicians]{musicians}} dataset.
Obtained with 5-fold stratified cross-validation (3 repetitions).
The three classifiers were fit using \code{nnet::multinom},
\code{randomForest::randomForest}, and \code{e1071::svm}.
}
\details{
Used formula: \code{"Class ~ Height + Age + Drums + Bass + Guitar + Keys + Vocals"}
}
\examples{
# Attach packages
library(cvms)
library(dplyr)

\donttest{
# Evaluate each fold column
predicted.musicians \%>\%
    dplyr::group_by(Classifier, `Fold Column`) \%>\%
    evaluate(
        target_col = "Target",
        prediction_cols = c("A", "B", "C", "D"),
        type = "multinomial"
    )

# Overall ID evaluation
# I.e. if we average all 9 sets of predictions,
# how well did we predict the targets?
overall_id_eval <- predicted.musicians \%>\%
    evaluate(
        target_col = "Target",
        prediction_cols = c("A", "B", "C", "D"),
        type = "multinomial",
        id_col = "ID"
    )
overall_id_eval
# Plot the confusion matrix
plot_confusion_matrix(overall_id_eval$`Confusion Matrix`[[1]])
}
}
\seealso{
musicians
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\keyword{data}
