% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_unassigned}
\alias{cvd_area_unassigned}
\title{List NHS areas without parent assignments for a given time period}
\usage{
cvd_area_unassigned(time_period_id, system_level_id = NULL)
}
\arguments{
\item{time_period_id}{Integer (required). The reporting period (time period) for which to find unassigned areas. Use \code{\link[=cvd_time_period_list]{cvd_time_period_list()}} to obtain valid IDs.}

\item{system_level_id}{Integer (optional). Restrict the search to areas at a specific system level (e.g., Practice, PCN, ICB). Use \code{\link[=cvd_area_system_level]{cvd_area_system_level()}} to find valid IDs for a given time period.}
}
\value{
A tibble containing details for all areas without parent assignments in the selected time period (and system level, if specified). Typical columns include:
\describe{
\item{AreaCode}{Character. Unique code for the NHS area (e.g., "L81117").}
\item{AreaID}{Integer. Unique identifier for the NHS area}
\item{AreaName}{Character. Name of the NHS area (e.g., "Pilning Surgery").}
\item{OdsCode}{Character. ODS (Organisation Data Service) code for the practice, if available. Often blank.}
\item{SystemLevelID}{Integer. Identifier for the system level (5 = GP practices).}
\item{SystemLevelName}{Character. Name of the system level (e.g., "Practice").}
}
If no data is found, returns a tibble describing the error.
}
\description{
Retrieves all NHS areas that have data in the specified reporting time period but do not have any parent areas assigned. These "unassigned" areas are unreachable via standard heirarchical navigation and may represent data issues or exceptional cases (e.g., England as the highest-level system).
}
\details{
\itemize{
\item Use this function to identify "orphaned" NHS areas or to understand top-level areas (e.g., England).
\item If \code{system_level_id = 1} (England), expect the only result to be England, since it has no parent.
\item This can help with data quality checks or to ensure all areas are accessible via parent/child navigation.
}
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2Funassigned}{CVDPREVENT API documentation: Areas unassigned}
}

\examples{
\donttest{
# Report four GP practices (system level ID = 5) without parent PCN details for time period 17:
cvd_area_unassigned(time_period_id = 17, system_level_id = 5) |>
  dplyr::slice_head(n = 4) |>
  dplyr::select(SystemLevelName, AreaID, AreaName)

# List unassigned top-level areas (system level ID = 1, England) for time period 17:
cvd_area_unassigned(time_period_id = 17, system_level_id = 1) |>
  dplyr::select(SystemLevelName, AreaID, AreaName)
}

}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
