% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_aau}
\alias{get_aau}
\title{Amino Acid Usage}
\usage{
get_aau(cf, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}
}
\value{
a matrix of amino acid frequencies for each CDS.
Each row corresponds to a sequence, and each column represents an amino acid.
}
\description{
Calculate Amino Acid Usage Frequencies of each CDS.
}
\examples{
# estimate amino acid frequencies of yeast CDSs
cf_all <- count_codons(yeast_cds)
aau_gene <- get_aau(cf_all)
head(aau_gene)

}
