% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_parsing.R
\name{parse_references_section}
\alias{parse_references_section}
\title{Parse references section from text}
\usage{
parse_references_section(references_text)
}
\arguments{
\item{references_text}{Character string. Text of references section.}
}
\value{
Tibble with columns:
\itemize{
\item ref_id: Unique reference identifier
\item ref_full_text: Complete reference text
\item ref_authors: Author string
\item ref_year: Publication year
\item ref_first_author: First author surname
\item ref_first_author_normalized: Lowercase first author
\item ref_second_author: Second author surname (if present)
\item ref_second_author_normalized: Lowercase second author
\item n_authors: Number of authors (99 = et al.)
}
}
\description{
Parses a references section into individual entries with extracted metadata
including authors, year, and title information.
}
\examples{
\dontrun{
refs_text <- doc$References
parsed_refs <- parse_references_section(refs_text)
}

}
