% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-ContainerS3.R
\docType{methods}
\name{ContainerS4}
\alias{ContainerS4}
\alias{\%in\%}
\alias{\%in\%,ANY,Container-method}
\alias{ANY,Container}
\alias{\%in\%,Container,ANY-method}
\alias{Container,ANY}
\alias{\%in\%,Container,Container-method}
\alias{Container,Container}
\title{S4 methods for Container}
\usage{
x \%in\% table

\S4method{\%in\%}{ANY,Container}(x, table)

\S4method{\%in\%}{Container,ANY}(x, table)

\S4method{\%in\%}{Container,Container}(x, table)
}
\arguments{
\item{x}{\code{Container} objects}

\item{table}{\code{Container} objects}
}
\value{
A \code{logical} vector indicating if each element of \code{x} is found
}
\description{
Membership operator for Container
}
\examples{
co <- container(a = 1, 2, b = 3)
c(1, 3, 5) \%in\% co                       # TRUE TRUE FALSE
c(x = 1, y = 2, z = 9) \%in\% co           # c(x = TRUE, y = TRUE, z = FALSE)
list(x = 1, y = 2, z = 9) \%in\% co        # c(x = TRUE, y = TRUE, z = FALSE)

co2 <- container(a = NA, b = 2)
v <- c(x = 1, y = NA_real_, z = 2)
v \%in\% co2                               # c(x = FALSE, y = FALSE, z = TRUE)
co2 \%in\% v                               # c(a = FALSE, b = TRUE)
}
