% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-ContainerR6.R
\docType{class}
\name{Container}
\alias{Container}
\title{Container Class}
\description{
This class implements a container data structure with typical
member functions to insert, delete and access elements from the container.
For the standard S3 interface, see \code{\link[=container]{container()}}.
}
\details{
This class inherits from class \link{Iterable} and serves as the base
class for \link{Deque}, \link{Set}, and \link{Dict}.
}
\examples{
co = Container$new(1:5, c = Container$new("a", 1), l = list())
co$print()
co$length()
co$names()
co$clear()

# Extract
co = Container$new(a = 1, b = 2, c = 3, d = 4)
co$at(1:2)
co$at(c(1, 4))
co$at(list("d", 2))
co$at2(1)

try(co$at(0:2))  # index must be > 0

co$peek_at(0:2)
co$peek_at(0:2, default = 1)

# Replace
co$replace(4, 9)
co$replace(9, 11)
co$replace_at(1, -1)

try(co$replace_at(11, 1)) # index 11 exceeds length of Container

# Delete
co$delete(-1)
co$delete_at(3)

try(co$delete_at(3))     # index 3 exceeds length of Container

co$discard(3)

co2 = Container$new(b = 0)
co2$add(0, name = "a")
co$update(co2)
co$pop(1)
co
}
\seealso{
\code{\link[=container]{container()}}, \link{Iterable}, \link{Deque}, \link{Set}, and \link{Dict}
}
\author{
Roman Pahl
}
\section{Super class}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{Container}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Container-new}{\code{Container$new()}}
\item \href{#method-Container-add}{\code{Container$add()}}
\item \href{#method-Container-at}{\code{Container$at()}}
\item \href{#method-Container-at2}{\code{Container$at2()}}
\item \href{#method-Container-clear}{\code{Container$clear()}}
\item \href{#method-Container-count}{\code{Container$count()}}
\item \href{#method-Container-delete}{\code{Container$delete()}}
\item \href{#method-Container-delete_at}{\code{Container$delete_at()}}
\item \href{#method-Container-discard}{\code{Container$discard()}}
\item \href{#method-Container-discard_at}{\code{Container$discard_at()}}
\item \href{#method-Container-empty}{\code{Container$empty()}}
\item \href{#method-Container-get_compare_fun}{\code{Container$get_compare_fun()}}
\item \href{#method-Container-has}{\code{Container$has()}}
\item \href{#method-Container-has_name}{\code{Container$has_name()}}
\item \href{#method-Container-is_empty}{\code{Container$is_empty()}}
\item \href{#method-Container-length}{\code{Container$length()}}
\item \href{#method-Container-names}{\code{Container$names()}}
\item \href{#method-Container-peek_at}{\code{Container$peek_at()}}
\item \href{#method-Container-peek_at2}{\code{Container$peek_at2()}}
\item \href{#method-Container-pop}{\code{Container$pop()}}
\item \href{#method-Container-print}{\code{Container$print()}}
\item \href{#method-Container-rename}{\code{Container$rename()}}
\item \href{#method-Container-replace}{\code{Container$replace()}}
\item \href{#method-Container-replace_at}{\code{Container$replace_at()}}
\item \href{#method-Container-remove}{\code{Container$remove()}}
\item \href{#method-Container-size}{\code{Container$size()}}
\item \href{#method-Container-type}{\code{Container$type()}}
\item \href{#method-Container-update}{\code{Container$update()}}
\item \href{#method-Container-values}{\code{Container$values()}}
\item \href{#method-Container-clone}{\code{Container$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter"><a href='../../container/html/Iterable.html#method-Iterable-iter'><code>container::Iterable$iter()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-new"></a>}}
\if{latex}{\out{\hypertarget{method-Container-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{initial elements put into the \code{Container}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-add"></a>}}
\if{latex}{\out{\hypertarget{method-Container-add}{}}}
\subsection{Method \code{add()}}{
add element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$add(value, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value of \code{ANY} type to be added to the \code{Container}.}

\item{\code{name}}{\code{character} optional name attribute of the value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-at"></a>}}
\if{latex}{\out{\hypertarget{method-Container-at}{}}}
\subsection{Method \code{at()}}{
Same as \code{at2} (see below) but accepts a vector of
indices and always returns a \code{Container} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$at(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{vector of indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{Container} object with the extracted elements.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-at2"></a>}}
\if{latex}{\out{\hypertarget{method-Container-at2}{}}}
\subsection{Method \code{at2()}}{
Extract value at index. If index is invalid or not
found, an error is signaled. If given as a string, the element
matching the name is returned. If there are two or more identical
names, the value of the first match (i.e. \emph{leftmost} element) is
returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$at2(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Must be a single number > 0 or a string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If given as a number, the element at the corresponding
position, and if given as a string, the element at the
corresponding name matching the given string is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Container-clear}{}}}
\subsection{Method \code{clear()}}{
delete all elements from the \code{Container}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the cleared \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-count"></a>}}
\if{latex}{\out{\hypertarget{method-Container-count}{}}}
\subsection{Method \code{count()}}{
Count number of element occurences.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$count(elem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elem}}{element to be counted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{integer} number of \code{elem} occurences in the \code{\link[=Container]{Container()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Container-delete}{}}}
\subsection{Method \code{delete()}}{
Search for occurence(s) of \code{elem} in \code{Container} and
remove first one that is found. If \code{elem} does not exist, an error
is signaled.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$delete(elem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elem}}{element to be removed from the \code{Container}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-delete_at"></a>}}
\if{latex}{\out{\hypertarget{method-Container-delete_at}{}}}
\subsection{Method \code{delete_at()}}{
Delete value at given index. If index is not found, an
error is signaled.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$delete_at(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{character} or \code{numeric} index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-discard"></a>}}
\if{latex}{\out{\hypertarget{method-Container-discard}{}}}
\subsection{Method \code{discard()}}{
Search for occurence(s) of \code{elem} in \code{Container} and
remove first one that is found.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$discard(elem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elem}}{element to be discarded from the \code{Container}. If not
found, the operation is ignored and the object is \emph{not} altered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-discard_at"></a>}}
\if{latex}{\out{\hypertarget{method-Container-discard_at}{}}}
\subsection{Method \code{discard_at()}}{
Discard value at given index. If index is not found,
the operation is ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$discard_at(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{character} or \code{numeric} index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-empty"></a>}}
\if{latex}{\out{\hypertarget{method-Container-empty}{}}}
\subsection{Method \code{empty()}}{
This function is deprecated. Use \code{\link[=is_empty]{is_empty()}} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-get_compare_fun"></a>}}
\if{latex}{\out{\hypertarget{method-Container-get_compare_fun}{}}}
\subsection{Method \code{get_compare_fun()}}{
Get comparison function used internally by the
\code{Container} object to compare elements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$get_compare_fun()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-has"></a>}}
\if{latex}{\out{\hypertarget{method-Container-has}{}}}
\subsection{Method \code{has()}}{
Determine if \code{Container} has some element.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$has(elem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elem}}{element to search for}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if \code{Container} contains \code{elem} else \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-has_name"></a>}}
\if{latex}{\out{\hypertarget{method-Container-has_name}{}}}
\subsection{Method \code{has_name()}}{
Determine if \code{Container} object contains an element
with the given name. If called with no argument, the function
determines whether \emph{any} element is named.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$has_name(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{character} the name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if \code{Container} has the \code{name} otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-Container-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Check if \code{Container} is empty
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the \code{Container} is empty else \code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-length"></a>}}
\if{latex}{\out{\hypertarget{method-Container-length}{}}}
\subsection{Method \code{length()}}{
Number of elements of the \code{Container}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{integer} length of the \code{Container}, that is, the number of
elements it contains.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-names"></a>}}
\if{latex}{\out{\hypertarget{method-Container-names}{}}}
\subsection{Method \code{names()}}{
Names of the elements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character} the names of the elements contained in \code{x}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-peek_at"></a>}}
\if{latex}{\out{\hypertarget{method-Container-peek_at}{}}}
\subsection{Method \code{peek_at()}}{
Same as \code{peek_at2} (see below) but accepts a vector of
indices and always returns a \code{Container} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$peek_at(index, default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{vector of indices.}

\item{\code{default}}{the default value to return in case the value at
\code{index} is not found.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{Container} object with the extracted elements.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-peek_at2"></a>}}
\if{latex}{\out{\hypertarget{method-Container-peek_at2}{}}}
\subsection{Method \code{peek_at2()}}{
Peek at index and extract value. If index is invalid,
missing, or not not found, return \code{default} value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$peek_at2(index, default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{numeric} or \code{character} index to be accessed.}

\item{\code{default}}{the default value to return in case the value at
\code{index} is not found.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the value at the given index or (if not found) the given
default value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-pop"></a>}}
\if{latex}{\out{\hypertarget{method-Container-pop}{}}}
\subsection{Method \code{pop()}}{
Get value at index and remove it from \code{Container}.
If \code{index} is not found, raise an error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$pop(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Must be a single number > 0 or a string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If given as a number, the element at the corresponding
position, and if given as a string, the element at the
corresponding name matching the given string is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-print"></a>}}
\if{latex}{\out{\hypertarget{method-Container-print}{}}}
\subsection{Method \code{print()}}{
Print object representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments passed to \code{\link[=format]{format()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly returns the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-rename"></a>}}
\if{latex}{\out{\hypertarget{method-Container-rename}{}}}
\subsection{Method \code{rename()}}{
Rename a \code{key} in the \code{Container}. An error is signaled,
if either the \code{old} key is not in the \code{Container} or the \code{new} key
results in a name-clash with an existing key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$rename(old, new)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{\code{character} name of key to be renamed.}

\item{\code{new}}{\code{character} new key name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-replace"></a>}}
\if{latex}{\out{\hypertarget{method-Container-replace}{}}}
\subsection{Method \code{replace()}}{
Replace one element by another element.
Search for occurence of \code{old} and, if found, replace it by \code{new}.
If \code{old} does not exist, an error is signaled, unless \code{add} was
set to \code{TRUE}, in which case \code{new} is added.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$replace(old, new, add = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{element to be replaced}

\item{\code{new}}{element to be put instead of old}

\item{\code{add}}{\code{logical} if \code{TRUE} the \code{new} element is added in case
\code{old} does not exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-replace_at"></a>}}
\if{latex}{\out{\hypertarget{method-Container-replace_at}{}}}
\subsection{Method \code{replace_at()}}{
Replace value at given index.
Replace value at index by given value. If index is not found, an
error is signalled, unless \code{add} was set to \code{TRUE}, in which case
\code{new} is added.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$replace_at(index, value, add = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{character} or \code{numeric} index}

\item{\code{value}}{\code{ANY} new value to replace the old one.}

\item{\code{add}}{\code{logical} if \code{TRUE} the new \code{value} element would be added
in case \code{index} did not exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Container-remove}{}}}
\subsection{Method \code{remove()}}{
This function is deprecated. Use \code{\link[=delete]{delete()}} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$remove(elem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elem}}{element to be deleted from the \code{Container}. If element
is not found in the \code{Container}, an error is signaled.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Container} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-size"></a>}}
\if{latex}{\out{\hypertarget{method-Container-size}{}}}
\subsection{Method \code{size()}}{
This function is deprecated. Use \code{\link[=length]{length()}} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the \code{Container} length
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-type"></a>}}
\if{latex}{\out{\hypertarget{method-Container-type}{}}}
\subsection{Method \code{type()}}{
This function is deprecated and of no real use anymore.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
type (or mode) of internal vector containing the elements
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-update"></a>}}
\if{latex}{\out{\hypertarget{method-Container-update}{}}}
\subsection{Method \code{update()}}{
Add elements of \code{other} to this if the name is
not in the \code{Container} and update elements with existing names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$update(other)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{\code{Iterable} object used to update this.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Container}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-values"></a>}}
\if{latex}{\out{\hypertarget{method-Container-values}{}}}
\subsection{Method \code{values()}}{
Get \code{Container} values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
elements of the container as a base list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Container-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Container-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Container$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
