% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_envs.R
\name{list_envs}
\alias{list_envs}
\title{List Installed Conda Environments}
\usage{
list_envs(verbose = "silent")
}
\arguments{
\item{verbose}{A character string indicating the verbosity level for the command.
Defaults to \code{"silent"}.
See \code{\link[=run]{run()}} for details.}
}
\value{
A character vector containing the names of installed Conda environments.
If the command fails, the function returns the process exit status as a numeric value.
}
\description{
This function retrieves a list of Conda environments installed in the \code{{condathis}}
environment directory. The returned value excludes any environments unrelated
to \code{{condathis}}, such as the base Conda environment itself.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  # Create environments
  condathis::create_env(
    packages = "fastqc",
    env_name = "fastqc-env"
  )
  condathis::create_env(
    packages = "python",
    env_name = "python-env"
  )

  # List environments
  condathis::list_envs()
  #> [1] "fastqc-env" "python-env"
})
}

}
