% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_grid.R
\name{random_search}
\alias{random_search}
\title{Random Search Solver}
\usage{
random_search(sampler, n = 100L)
}
\arguments{
\item{sampler}{Function generating random parameter vectors}

\item{n}{Number of random points to evaluate}
}
\value{
A solver function
}
\description{
Creates a solver that evaluates the log-likelihood at random points
and returns the best. Useful for high-dimensional problems where
grid search is infeasible.
}
\details{
Unlike grid search, random search scales better to high dimensions.
The sampler should generate points in a reasonable region; points
outside the problem's constraint support are skipped.
}
\examples{
# Create a random search solver with uniform sampling
solver <- random_search(
  sampler = uniform_sampler(c(-10, 0.1), c(10, 5)),
  n = 100
)

}
