% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{num_iterations}
\alias{num_iterations}
\title{Get number of iterations}
\usage{
num_iterations(x, ...)
}
\arguments{
\item{x}{An mle result object}

\item{...}{Additional arguments (unused)}
}
\value{
Number of iterations, or \code{NA_integer_} if not available.
}
\description{
Get number of iterations
}
\examples{
\donttest{
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(1, 2))^2)
)
result <- gradient_ascent(max_iter = 50)(problem, c(0, 0))
num_iterations(result)
}
}
