% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_plot_1d_advanced.R
\name{render_plot_1d_advanced}
\alias{render_plot_1d_advanced}
\title{Plotting routine designed for the CM SAF R Toolbox.}
\usage{
render_plot_1d_advanced(
  outfile = NULL,
  fileExtension = ".png",
  visualizeVariables,
  ticknumber,
  addTrend,
  sliderx,
  slidery,
  checkGroup_type,
  imagewidth,
  imageheight,
  text1_1d,
  text2_1d,
  textsize,
  linesize,
  col,
  timestep_1d_visualize
)
}
\arguments{
\item{outfile}{Name of the outfile (NULL or character). Should match the fileExtension.
If NULL is passed a file is created in the R session temporary directory.}

\item{fileExtension}{The file extension of the image (character). Has to be one of the following: 'png', 'jpg', 'tif', 'kml', 'pdf'.}

\item{visualizeVariables}{A data frame containing all meta data for the plotting process (data.frame).}

\item{ticknumber}{Number of ticks (numeric).}

\item{addTrend}{Whether to add a trend line (logical).}

\item{sliderx}{Limiting the time series with a two valued vector for min and max (numeric).}

\item{slidery}{Limiting the y axis with a two valued vector for min and max (numeric).}

\item{checkGroup_type}{Integer in 1-5. See Details. (numeric)}

\item{imagewidth}{Width of the image (numeric).}

\item{imageheight}{Height of the image (numeric).}

\item{text1_1d}{Title text (character).}

\item{text2_1d}{Text to be passed to graphics::mtext (character).}

\item{textsize}{Textsize to be used (cex).}

\item{linesize}{Line width to be used (positive numeric).}

\item{col}{A color chosen via colourpicker::colourInput.}

\item{timestep_1d_visualize}{The time step to be visualized.}
}
\description{
This function renders a 1D plot of data at one single lon or one single lat point.
}
\details{
\describe{
\item{1}{Line}
\item{2}{Points}
\item{3}{Line and Points}
\item{4}{Steps}
\item{5}{Histogram}
}
}
