\name{wells_dvt_score}
\alias{wells_dvt_score}
\title{
Wells' Criteria for DVT
}
\description{
Calculates the Wells' Criteria risk stratification score for Deep Vein Thrombosis (DVT). The score classifies patients into 'Likely' or 'Unlikely' probability groups to guide diagnostic testing (e.g., D-dimer vs. Ultrasound).
}
\usage{
wells_dvt_score(active_cancer, paralysis_paresis, bedridden_recently_surgery,
                localized_tenderness, entire_leg_swollen, calf_swelling_gt_3cm,
                pitting_edema, collateral_superficial_veins, history_dvt,
                alternative_diagnosis_likely)
}
\arguments{
  \item{active_cancer}{
Numeric (0 or 1). Active cancer (treatment ongoing, within 6 months, or palliative). (1 = Yes, +1 point).
}
  \item{paralysis_paresis}{
Numeric (0 or 1). Paralysis, paresis, or recent plaster immobilization of the lower extremities. (1 = Yes, +1 point).
}
  \item{bedridden_recently_surgery}{
Numeric (0 or 1). Recently bedridden > 3 days or major surgery within 4 weeks requiring general or regional anesthesia. (1 = Yes, +1 point).
}
  \item{localized_tenderness}{
Numeric (0 or 1). Localized tenderness along the distribution of the deep venous system. (1 = Yes, +1 point).
}
  \item{entire_leg_swollen}{
Numeric (0 or 1). Entire leg swollen. (1 = Yes, +1 point).
}
  \item{calf_swelling_gt_3cm}{
Numeric (0 or 1). Calf swelling > 3 cm compared to the asymptomatic leg (measured 10 cm below tibial tuberosity). (1 = Yes, +1 point).
}
  \item{pitting_edema}{
Numeric (0 or 1). Pitting edema confined to the symptomatic leg. (1 = Yes, +1 point).
}
  \item{collateral_superficial_veins}{
Numeric (0 or 1). Collateral superficial veins (non-varicose). (1 = Yes, +1 point).
}
  \item{history_dvt}{
Numeric (0 or 1). Previously documented DVT. (1 = Yes, +1 point).
}
  \item{alternative_diagnosis_likely}{
Numeric (0 or 1). Alternative diagnosis at least as likely as DVT. (1 = Yes, -2 points).
}
}
\value{
A list containing:
\item{Wells_Score}{The calculated score (Range -2 to 9).}
\item{Risk_Category}{Classification (Unlikely <2, Likely >=2).}
\item{Probability}{Estimated prevalence of DVT in the risk group.}
}
\references{
Wells PS, Anderson DR, Bormanis J, et al. Value of assessment of pretest probability of deep-vein thrombosis in clinical management. Lancet. 1997;350(9094):1795-1798. doi:10.1016/S0140-6736(97)08140-3
}
\examples{

# Example 1: DVT Likely
# Cancer (+1), Swelling >3cm (+1), Tenderness (+1)
# Score = 3
wells_dvt_score(1, 0, 0, 1, 0, 1, 0, 0, 0, 0)

# Example 2: DVT Unlikely
# Recent surgery (+1), but alternative diagnosis likely (-2)
# Score = -1
wells_dvt_score(0, 0, 1, 0, 0, 0, 0, 0, 0, 1)
}
