\name{us_medped_fh_criteria}
\alias{us_medped_fh_criteria}
\title{
US MEDPED Diagnostic Criteria for Familial Hypercholesterolemia (FH)
}
\description{
Calculates the US MEDPED (Make Early Diagnosis to Prevent Early Deaths) diagnostic criteria for Familial Hypercholesterolemia. The diagnosis is based on age-specific total cholesterol thresholds and the degree of relationship to a known relative with FH.
}
\usage{
us_medped_fh_criteria(age, total_cholesterol, relative_with_fh, units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{total_cholesterol}{
Numeric. Total cholesterol level.
}
  \item{relative_with_fh}{
String. The degree of relationship to a relative diagnosed with FH.
Options:
"first_degree" (Parent, Sibling, Child).
"second_degree" (Grandparent, Aunt/Uncle, Niece/Nephew, Half-sibling).
"third_degree" (First Cousin).
"general_population" (No known relative with FH).
}
  \item{units}{
String. Units for cholesterol input. Options: "mg/dL" (default) or "mmol/L".
}
}
\details{
Thresholds (mg/dL) for diagnosis:
\strong{First Degree:} <20y (220), 20-29y (240), 30-39y (270), >=40y (290).
\strong{Second Degree:} <20y (230), 20-29y (250), 30-39y (280), >=40y (300).
\strong{Third Degree:} <20y (240), 20-29y (260), 30-39y (290), >=40y (310).
\strong{General Population:} <20y (270), 20-29y (290), 30-39y (340), >=40y (360).
}
\value{
A list containing:
\item{Diagnosis}{"Diagnosed with Familial Hypercholesterolemia (FH)" or "Does Not Meet Criteria for FH".}
\item{Threshold_Used_mg_dL}{The specific cholesterol cutoff used for the assessment.}
}
\references{
Williams RR, Hunt SC, Schumacher MC, et al. Diagnosing heterozygous familial hypercholesterolemia using new practical criteria validated by molecular genetics. Am J Cardiol. 1993;72(2):171-176. doi:10.1016/0002-9149(93)90155-6
}
\examples{

# Example 1: FH Diagnosed
# 35yo, Cholesterol 300 mg/dL, First-degree relative with FH
us_medped_fh_criteria(35, 300, "first_degree")

# Example 2: Not FH
# 50yo, Cholesterol 250 mg/dL, General Population
us_medped_fh_criteria(50, 250, "general_population")
}
