\name{tlics_score}
\alias{tlics_score}
\title{
Thoracolumbar Injury Classification and Severity Scale (TLICS)
}
\description{
Calculates the TLICS score to guide the surgical or non-surgical management of thoracolumbar spine trauma. The score is based on three categories: Injury Morphology, Neurological Status, and Integrity of the Posterior Ligamentous Complex (PLC).
}
\usage{
tlics_score(injury_morphology, neurological_status, plc_integrity)
}
\arguments{
  \item{injury_morphology}{
String. Mechanism/Morphology of injury.
"compression": Compression fracture (1 pt).
"burst": Burst fracture (2 pts).
"translation_rotation": Translational/Rotational injury (3 pts).
"distraction": Distraction injury (4 pts).
}
  \item{neurological_status}{
String. Neurological status of the patient.
"intact": Neurologically intact (0 pts).
"root": Nerve root injury (2 pts).
"complete": Complete spinal cord injury (2 pts).
"incomplete": Incomplete spinal cord injury (3 pts).
"cauda_equina": Cauda Equina Syndrome (3 pts).
}
  \item{plc_integrity}{
String. Status of the Posterior Ligamentous Complex.
"intact": Intact (0 pts).
"suspected": Injury suspected/Indeterminate (2 pts).
"injured": Injured (3 pts).
}
}
\value{
A list containing:
\item{TLICS_Score}{The calculated total score (Range 1-10).}
\item{Recommendation}{Clinical management guidance (Non-Operative <= 3, Indeterminate = 4, Operative >= 5).}
}
\references{
Vaccaro AR, Lehman RA Jr, Hurlbert RJ, et al. A new classification of thoracolumbar injuries: the importance of injury morphology, the integrity of the posterior ligamentous complex, and neurologic status. Spine (Phila Pa 1976). 2005;30(20):2325-2333. doi:10.1097/01.brs.0000182956.43171.a5
}
\examples{

# Example 1: Non-Operative
# Compression fx (1), Intact Neuro (0), Intact PLC (0)
# Score = 1
tlics_score("compression", "intact", "intact")

# Example 2: Operative
# Burst fx (2), Incomplete Injury (3), Suspected PLC (2)
# Score = 7
tlics_score("burst", "incomplete", "suspected")
}
