\name{surgical_apgar_score}
\alias{surgical_apgar_score}
\title{
Surgical Apgar Score (SAS)
}
\description{
Calculates the Surgical Apgar Score, a 10-point scoring system used to predict 30-day major complications or death after general or vascular surgery. It utilizes three intraoperative variables: estimated blood loss, lowest mean arterial pressure, and lowest heart rate.
}
\usage{
surgical_apgar_score(blood_loss_ml, lowest_map_mmhg, lowest_heart_rate)
}
\arguments{
  \item{blood_loss_ml}{
Numeric. Estimated blood loss in milliliters (mL).
}
  \item{lowest_map_mmhg}{
Numeric. The lowest mean arterial pressure recorded during the procedure (mmHg).
}
  \item{lowest_heart_rate}{
Numeric. The lowest heart rate recorded during the procedure (beats per minute). Note: While counter-intuitive, lower intraoperative heart rates are associated with better outcomes in this specific risk model, likely due to beta-blockade or lack of stress response.
}
}
\details{
The score ranges from 0 to 10, where a lower score indicates a higher risk of complications.
Scoring logic:
Blood Loss: <=100 (3), 101-600 (2), 601-1000 (1), >1000 (0).
Lowest MAP: >=75 (3), 55-74 (2), 40-54 (1), <40 (0).
Lowest HR: <=55 (3), 56-65 (2), 66-75 (1), >75 (0).
}
\value{
A list containing:
\item{SAS_Score}{The calculated total score.}
\item{Risk_Category}{Risk classification (High, Medium, Low, Very Low).}
\item{Risk_Estimate}{Estimated 30-day complication or mortality rate.}
}
\references{
Gawande AA, Kwaan MR, Regenbogen SE, Lipsitz SA, Zinner MJ. An Apgar score for surgery. J Am Coll Surg. 2007;204(2):201-208. doi:10.1016/j.jamcollsurg.2006.11.011
}
\examples{

# Example 1: High Risk Patient
# High blood loss, low MAP, high HR
surgical_apgar_score(1200, 35, 90)

# Example 2: Low Risk Patient
# Minimal blood loss, stable MAP, low HR
surgical_apgar_score(50, 80, 50)
}
