\name{sdai_rheumatoid_arthritis}
\alias{sdai_rheumatoid_arthritis}
\title{
Simple Disease Activity Index (SDAI) for Rheumatoid Arthritis
}
\description{
Calculates the SDAI score to assess disease activity in Rheumatoid Arthritis. The score is a simple sum of five components: tender joint count (28), swollen joint count (28), patient global assessment (0-10), provider global assessment (0-10), and C-reactive protein (mg/dL).
}
\usage{
sdai_rheumatoid_arthritis(tender_joint_count_28, swollen_joint_count_28,
                          patient_global_assessment, provider_global_assessment,
                          crp_mg_dl)
}
\arguments{
  \item{tender_joint_count_28}{
Numeric (0-28). Number of tender joints upon examination.
}
  \item{swollen_joint_count_28}{
Numeric (0-28). Number of swollen joints upon examination.
}
  \item{patient_global_assessment}{
Numeric (0-10). Patient's global assessment of disease activity on a 0-10 visual analog scale (VAS).
}
  \item{provider_global_assessment}{
Numeric (0-10). Provider's global assessment of disease activity on a 0-10 visual analog scale (VAS).
}
  \item{crp_mg_dl}{
Numeric. Serum C-Reactive Protein level in mg/dL.
}
}
\value{
A list containing:
\item{SDAI_Score}{The calculated total score (Sum of 5 components).}
\item{Disease_Activity}{Classification (Remission <= 3.3, Low <= 11, Moderate <= 26, High > 26).}
}
\references{
Smolen JS, Breedveld FC, Schiff MH, et al. A simplified disease activity index for rheumatoid arthritis for use in clinical practice. Rheumatology (Oxford). 2003;42(2):244-257. doi:10.1093/rheumatology/keg072
}
\examples{

# Example 1: High Activity
# 10 tender, 8 swollen, Pat GA 6, Prov GA 5, CRP 2.0
# Score = 10 + 8 + 6 + 5 + 2.0 = 31
sdai_rheumatoid_arthritis(10, 8, 6, 5, 2.0)

# Example 2: Remission
# 0 tender, 0 swollen, Pat GA 0.5, Prov GA 0.5, CRP 0.2
# Score = 0 + 0 + 0.5 + 0.5 + 0.2 = 1.2
sdai_rheumatoid_arthritis(0, 0, 0.5, 0.5, 0.2)
}
