\name{rome_iv_infant_dyschezia}
\alias{rome_iv_infant_dyschezia}
\title{
Rome IV Diagnostic Criteria for Infant Dyschezia
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Infant Dyschezia**, a common functional gastrointestinal disorder of infancy. The condition is characterized by straining and crying for at least 10 minutes prior to the successful passage of soft stool, occurring in infants less than 9 months old.
}
\usage{
rome_iv_infant_dyschezia(age_lt_9mo, duration_ge_10min, crying_straining,
                         eventual_successful_stool, no_other_illness)
}
\arguments{
  \item{age_lt_9mo}{
Numeric (0 or 1). Is the infant under **9 months of age**? (1 = Yes). This is a required criterion.
}
  \item{duration_ge_10min}{
Numeric (0 or 1). Does the infant strain and cry for at least **10 minutes** prior to stool passage? (1 = Yes).
}
  \item{crying_straining}{
Numeric (0 or 1). Is the primary presentation **crying and straining**? (1 = Yes).
}
  \item{eventual_successful_stool}{
Numeric (0 or 1). Does the straining resolve with the passage of **soft stool** (i.e., not hard stool)? (1 = Yes).
}
  \item{no_other_illness}{
Numeric (0 or 1). Is there an **absence of other illness** or organic condition to explain the symptoms? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Infant Dyschezia" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# Age 6mo, Cries >10min, Straining, Soft stool follows, No other illness
rome_iv_infant_dyschezia(1, 1, 1, 1, 1)

# Example 2: Not Met (Hard Stool passed - likely Constipation)
# Age 4mo, Cries >10min, Straining, Hard stool passed (0 for successful soft stool)
rome_iv_infant_dyschezia(1, 1, 1, 0, 1)
}
