\name{rifle_criteria_aki}
\alias{rifle_criteria_aki}
\title{
RIFLE Criteria for Acute Kidney Injury (AKI)
}
\description{
Calculates the RIFLE classification (Risk, Injury, Failure, Loss, End-stage) for Acute Kidney Injury. The classification is based on the worst of either serum creatinine/GFR criteria or urine output criteria. 'Loss' and 'End-stage' are outcome categories determined by the duration of kidney failure, which are not calculated by this function (typically >4 weeks and >3 months, respectively).
}
\usage{
rifle_criteria_aki(baseline_creatinine, current_creatinine, gfr_decrease_percent,
                   urine_output_ml_kg_hr, urine_output_duration_hours,
                   anuria_duration_hours)
}
\arguments{
  \item{baseline_creatinine}{
Numeric. Baseline serum creatinine level (mg/dL).
}
  \item{current_creatinine}{
Numeric. Current serum creatinine level (mg/dL).
}
  \item{gfr_decrease_percent}{
Numeric. Percentage decrease in GFR (if known). Set to 0 if unknown. (25\% = Risk, 50\% = Injury, 75\% = Failure).
}
  \item{urine_output_ml_kg_hr}{
Numeric. Urine output rate in mL/kg/hr.
}
  \item{urine_output_duration_hours}{
Numeric. Duration of decreased urine output in hours.
}
  \item{anuria_duration_hours}{
Numeric. Duration of anuria in hours.
}
}
\value{
A list containing:
\item{RIFLE_Class}{The final determined RIFLE class (Risk, Injury, Failure, or No AKI).}
\item{GFR_Criteria_Class}{Classification based on creatinine/GFR criteria alone.}
\item{Urine_Output_Criteria_Class}{Classification based on urine output criteria alone.}
}
\references{
Bellomo R, Ronco C, Kellum JA, et al. Acute renal failure - definition, outcome measures, animal models, fluid therapy and information technology needs: the Second International Consensus Conference of the Acute Dialysis Quality Initiative (ADQI) Group. Crit Care. 2004;8(4):R204-212. doi:10.1186/cc2872
}
\examples{

# Example 1: Injury Class (High Creatinine)
# Baseline Cr 1.0, Current Cr 2.5 (>2x increase)
rifle_criteria_aki(1.0, 2.5, 0, 1.0, 0, 0)

# Example 2: Failure Class (Low Urine Output)
# Cr normal, UO < 0.3 ml/kg/h for 24 hours
rifle_criteria_aki(1.0, 1.1, 0, 0.2, 24, 0)
}
