\name{revised_tokuhashi_score}
\alias{revised_tokuhashi_score}
\title{
Revised Tokuhashi Score for Metastatic Spine Tumor Prognosis
}
\description{
Calculates the Revised Tokuhashi Score (2005) to estimate the prognosis and guide treatment for patients with metastatic spinal tumors. The score evaluates six parameters: general condition (KPS), number of extraspinal bone metastases, number of vertebral metastases, metastases to major internal organs, primary site of cancer, and spinal cord palsy severity.
}
\usage{
revised_tokuhashi_score(kps, number_extraspinal_bone_mets, number_vertebral_mets,
                        major_organ_metastases, primary_site_group, palsy_frankel)
}
\arguments{
  \item{kps}{
Numeric. Karnofsky Performance Status score (0-100).
<50: 0 pts.
50-70: 1 pt.
80-100: 2 pts.
}
  \item{number_extraspinal_bone_mets}{
Numeric. Number of extraspinal bone metastases.
>=3: 0 pts.
1-2: 1 pt.
0: 2 pts.
}
  \item{number_vertebral_mets}{
Numeric. Number of metastases in the vertebral body.
>=3: 0 pts.
2: 1 pt.
1: 2 pts.
}
  \item{major_organ_metastases}{
String. Status of metastases to major internal organs (lungs, liver, kidneys, brain).
"unremovable": 0 pts.
"removable": 1 pt.
"none": 2 pts.
}
  \item{primary_site_group}{
String. The primary cancer site.
"lung", "osteosarcoma", "stomach", "bladder", "esophagus", "pancreas": 0 pts.
"liver", "gallbladder", "unidentified": 1 pt.
"others": 2 pts.
"kidney", "uterus": 3 pts.
"rectum": 4 pts.
"thyroid", "breast", "prostate", "carcinoid": 5 pts.
}
  \item{palsy_frankel}{
String. Severity of spinal cord palsy based on Frankel Classification.
"complete" (Frankel A, B): 0 pts.
"incomplete" (Frankel C, D): 1 pt.
"none" (Frankel E): 2 pts.
}
}
\value{
A list containing:
\item{Tokuhashi_Score}{The calculated total score (Range 0-15).}
\item{Prognosis}{Estimated life expectancy (<6 months, >=6 months, >=1 year).}
\item{Treatment_Recommendation}{Suggested surgical or conservative approach based on prognosis.}
}
\references{
Tokuhashi Y, Matsuzaki H, Oda H, Oshima M, Ryu J. A revised scoring system for preoperative evaluation of metastatic spine tumor prognosis. Spine (Phila Pa 1976). 2005;30(19):2186-2191. doi:10.1097/01.brs.0000180401.06919.a5
}
\examples{

# Example 1: Poor Prognosis
# KPS 40 (0), 3 Extraspinal (0), 3 Vertebral (0),
#Unremovable Organ Mets (0), Lung CA (0), Complete Palsy (0)
# Score = 0
revised_tokuhashi_score(40, 3, 3, "unremovable", "lung", "complete")

# Example 2: Good Prognosis
# KPS 90 (2), 0 Extraspinal (2), 1 Vertebral (2), No Organ Mets (2), Breast CA (5), No Palsy (2)
# Score = 15
revised_tokuhashi_score(90, 0, 1, "none", "breast", "none")
}
