\name{priest_score}
\alias{priest_score}
\title{
PRIEST COVID-19 Clinical Severity Score
}
\description{
Calculates the PRIEST score to triage patients with suspected or confirmed COVID-19 in the emergency department. The score predicts the risk of death or requirement for organ support (intubation, non-invasive ventilation, vasopressors, or renal replacement therapy) within 30 days.
}
\usage{
priest_score(sex, age_years, respiratory_rate, oxygen_saturation, heart_rate,
             systolic_bp, temperature, alertness_status, performance_status)
}
\arguments{
  \item{sex}{
String. "male" (+1) or "female" (0).
}
  \item{age_years}{
Numeric. Patient age. (50-64: +2, 65-79: +3, >=80: +4).
}
  \item{respiratory_rate}{
Numeric. Breaths per minute. (>24: +3, 21-24: +2).
}
  \item{oxygen_saturation}{
Numeric. SpO2 percentage. (<92: +3, 92-93: +2, 94-95: +1).
}
  \item{heart_rate}{
Numeric. Beats per minute. (>130: +3, 111-130: +2, 91-110: +1).
}
  \item{systolic_bp}{
Numeric. Systolic Blood Pressure in mmHg. (<90: +3, 90-100: +2, 101-110: +1).
}
  \item{temperature}{
Numeric. Body temperature in Celsius. (<35.0: +3, 35.0-36.0: +2, 36.1-38.0: 0, 38.1-39.0: +1, >39.0: +2).
}
  \item{alertness_status}{
String. "alert" (0) or "confused_or_not_alert" (+3).
}
  \item{performance_status}{
Numeric (0-4). WHO Performance Status.
0: Unrestricted activity (0).
1-2: Restricted strenuous activity / Capable of self-care but unable to work (+1).
3-4: Limited self-care / Completely disabled (+3).
}
}
\value{
A list containing:
\item{PRIEST_Score}{The calculated total score (Range 0-29).}
\item{Risk_Category}{Risk stratification (Low, Medium, High, Very High).}
\item{Outcome_Prediction_30_Day}{Estimated 30-day risk of adverse outcome.}
}
\references{
Goodacre S, Thomas B, Sutton L, et al. Derivation and validation of a clinical severity score for acutely ill adults with suspected COVID-19: The PRIEST observational cohort study. PLoS One. 2021;16(1):e0245840. doi:10.1371/journal.pone.0245840
}
\examples{

# Example 1: Low Risk
# Female, 30yo, RR 18, SpO2 98, HR 80, SBP 120, Temp 37, Alert, PS 0
# Score = 0
priest_score("female", 30, 18, 98, 80, 120, 37.0, "alert", 0)

# Example 2: High Risk
# Male (+1), 70yo (+3), RR 22 (+2), SpO2 93 (+2),
#HR 100 (+1), SBP 105 (+1), Temp 38.5 (+1), Alert, PS 2 (+1)
# Score = 12
priest_score("male", 70, 22, 93, 100, 105, 38.5, "alert", 2)
}
