\name{pram_score}
\alias{pram_score}
\title{
Pediatric Respiratory Assessment Measure (PRAM)
}
\description{
Calculates the PRAM score to assess the severity of airway obstruction in pediatric patients (ages 1-17) with acute asthma exacerbations. The score evaluates five clinical signs: suprasternal retractions, scalene muscle contraction, air entry, wheezing, and oxygen saturation.
}
\usage{
pram_score(suprasternal_retractions, scalene_muscle_contraction, air_entry,
           wheezing, oxygen_saturation)
}
\arguments{
  \item{suprasternal_retractions}{
Numeric (0 or 1). Presence of suprasternal retractions. (1 = Present [+2 pts], 0 = Absent).
}
  \item{scalene_muscle_contraction}{
Numeric (0 or 1). Presence of scalene muscle contraction. (1 = Present [+2 pts], 0 = Absent).
}
  \item{air_entry}{
Numeric (0-2). Assessment of air entry.
0: Normal.
1: Decreased at the base.
2: Widespread decrease.
}
  \item{wheezing}{
Numeric (0-3). Assessment of wheezing.
0: Absent.
1: Expiratory only.
2: Inspiratory and Expiratory.
3: Audible without stethoscope or silent chest.
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation (\%) on room air.
>= 95\%: 0 pts.
92-94\%: 1 pt.
< 92\%: 2 pts.
}
}
\value{
A list containing:
\item{PRAM_Score}{The calculated total score (Range 0-12).}
\item{Severity_Classification}{Interpretation of severity (Mild 0-3, Moderate 4-7, Severe 8-12).}
}
\references{
Chalut DS, Ducharme FM, Davis GM. The Preschool Respiratory Assessment Measure (PRAM): a responsive index of acute asthma severity. J Pediatr. 2000;137(6):762-768. doi:10.1067/mpd.2000.109119
}
\examples{

# Example 1: Moderate Severity
# Retractions (2), Scalene (0), Air Entry Decreased Base (1), Exp Wheeze (1), SpO2 93% (1)
# Score = 5
pram_score(1, 0, 1, 1, 93)

# Example 2: Severe Severity
# Retractions (2), Scalene (2), Widespread decrease (2), Insp/Exp Wheeze (2), SpO2 90% (2)
# Score = 10
pram_score(1, 1, 2, 2, 90)
}
