\name{phenytoin_correction}
\alias{phenytoin_correction}
\title{
Phenytoin (Dilantin) Correction for Albumin and Renal Failure
}
\description{
Calculates the corrected phenytoin level using the Sheiner-Tozer equation. Phenytoin is highly protein-bound (typically ~90\% to albumin). In states of hypoalbuminemia or uremia (renal failure), the fraction of free (active) phenytoin increases, making total serum levels misleadingly low. This correction estimates the phenytoin level as if the patient had normal protein binding, allowing for comparison with the standard therapeutic range (10-20 mcg/mL).
}
\usage{
phenytoin_correction(measured_phenytoin, albumin, renal_failure)
}
\arguments{
  \item{measured_phenytoin}{
Numeric. The measured total serum phenytoin level in mcg/mL (or mg/L).
}
  \item{albumin}{
Numeric. The patient's serum albumin level in g/dL.
}
  \item{renal_failure}{
Numeric (0 or 1). Presence of end-stage renal disease (CrCl < 10-15 mL/min or on dialysis). (1 = Yes, 0 = No).
}
}
\details{
The formulas used are:
\itemize{
  \item \strong{Normal Renal Function:} \eqn{Corrected = \frac{Measured}{(0.2 \times Albumin) + 0.1}}
  \item \strong{Renal Failure / Uremia:} \eqn{Corrected = \frac{Measured}{(0.1 \times Albumin) + 0.1}}
}
Note: The factor 0.2 represents the normal free fraction (10\%) divided by the normal albumin (approx 4.4 g/dL). In uremia, the affinity of albumin for phenytoin is decreased, necessitating a different coefficient (0.1).
}
\value{
A list containing:
\item{Corrected_Phenytoin_mcg_mL}{The estimated corrected total phenytoin level.}
}
\references{
Sheiner LB, Tozer TN. Clinical pharmacokinetics: the use of plasma concentrations of drugs. In: Melmon KL, Morrelli HF, eds. Clinical Pharmacology: Basic Principles in Therapeutics. 2nd ed. New York, NY: Macmillan; 1978:71-109.
Winter ME. Phenytoin. In: Basic Clinical Pharmacokinetics. 3rd ed. Vancouver, WA: Applied Therapeutics, Inc; 1994.
}
\examples{

# Example 1: Hypoalbuminemia (Alb 2.5) with Normal Renal Function
# Measured 8 mcg/mL -> Corrected = 8 / ((0.2*2.5) + 0.1) = 8 / 0.6 = 13.3
phenytoin_correction(8, 2.5, 0)

# Example 2: Renal Failure (Alb 3.0)
# Measured 8 mcg/mL -> Corrected = 8 / ((0.1*3.0) + 0.1) = 8 / 0.4 = 20.0
phenytoin_correction(8, 3.0, 1)
}
