\name{ottawa_knee_rule}
\alias{ottawa_knee_rule}
\title{
Ottawa Knee Rule
}
\description{
Calculates the Ottawa Knee Rule to determine the need for knee radiography (X-ray) in patients with acute knee injury. The rule is highly sensitive for detecting fractures, allowing clinicians to safely rule out fractures without imaging if none of the criteria are met.
}
\usage{
ottawa_knee_rule(age, isolated_patella_tenderness, fibula_head_tenderness,
                 inability_to_flex_90, inability_to_bear_weight)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Age >= 55 is a positive criterion).
}
  \item{isolated_patella_tenderness}{
Numeric (0 or 1). Is there isolated tenderness of the patella (no bone tenderness of the knee other than the patella)? (1 = Yes).
}
  \item{fibula_head_tenderness}{
Numeric (0 or 1). Is there tenderness at the head of the fibula? (1 = Yes).
}
  \item{inability_to_flex_90}{
Numeric (0 or 1). Is the patient unable to flex the knee to 90 degrees? (1 = Yes).
}
  \item{inability_to_bear_weight}{
Numeric (0 or 1). Is the patient unable to bear weight both immediately after the injury and in the emergency department (defined as taking 4 steps, even if limping)? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for X-ray ("Indicated" or "Not Indicated").}
\item{Reasoning}{List of specific criteria met that triggered the indication.}
\item{Test_Characteristics}{Note on the sensitivity of the rule.}
}
\references{
Stiell IG, Greenberg GH, Wells GA, et al. Derivation of a decision rule for the use of radiography in acute knee injuries. Ann Emerg Med. 1995;26(4):405-413. doi:10.1016/s0196-0644(95)70106-0
}
\examples{

# Example 1: X-ray Indicated (Age)
# 60yo, no other symptoms
# Result: Indicated
ottawa_knee_rule(60, 0, 0, 0, 0)

# Example 2: X-ray Indicated (Inability to flex)
# 30yo, Unable to flex to 90 degrees
# Result: Indicated
ottawa_knee_rule(30, 0, 0, 1, 0)

# Example 3: No X-ray
# 25yo, Minor pain, able to walk, full flexion, no bony tenderness
# Result: Not Indicated
ottawa_knee_rule(25, 0, 0, 0, 0)
}
