\name{murray_lung_injury_score}
\alias{murray_lung_injury_score}
\title{
Murray Score for Acute Lung Injury
}
\description{
Calculates the Murray Lung Injury Score (LIS) to assess the severity of Acute Respiratory Distress Syndrome (ARDS). The score averages four components: Hypoxemia (PaO2/FiO2), PEEP, Respiratory Compliance, and Chest X-ray infiltration.
}
\usage{
murray_lung_injury_score(pao2_fio2_ratio, peep, respiratory_compliance,
                         cxr_quadrants)
}
\arguments{
  \item{pao2_fio2_ratio}{
Numeric. Ratio of arterial oxygen partial pressure to fractional inspired oxygen (PaO2/FiO2).
>=300: 0 pts.
225-299: 1 pt.
175-224: 2 pts.
100-174: 3 pts.
<100: 4 pts.
}
  \item{peep}{
Numeric. Positive End-Expiratory Pressure (cmH2O).
<=5: 0 pts.
6-8: 1 pt.
9-11: 2 pts.
12-14: 3 pts.
>=15: 4 pts.
}
  \item{respiratory_compliance}{
Numeric. Respiratory system compliance (mL/cmH2O). Typically calculated as Tidal Volume / (Plateau Pressure - PEEP).
>=80: 0 pts.
60-79: 1 pt.
40-59: 2 pts.
20-39: 3 pts.
<=19: 4 pts.
}
  \item{cxr_quadrants}{
Numeric (0-4). Number of quadrants showing alveolar consolidation on Chest X-ray.
0: 0 pts.
1: 1 pt.
2: 2 pts.
3: 3 pts.
4: 4 pts.
}
}
\value{
A list containing:
\item{Murray_Score}{The calculated Lung Injury Score (average of the 4 components, Range 0-4).}
\item{Severity_Assessment}{Interpretation (No Injury = 0, Mild-Moderate 0.1-2.5, Severe > 2.5).}
\item{Subscores}{Individual points assigned to each component.}
}
\references{
Murray JF, Matthay MA, Luce JM, Flick MR. An expanded definition of the adult respiratory distress syndrome. Am Rev Respir Dis. 1988;138(3):720-723. doi:10.1164/ajrccm/138.3.720
}
\examples{

# Example 1: Severe ARDS
# PF 80 (4 pts), PEEP 16 (4 pts), Compliance 18 (4 pts), CXR 4 quads (4 pts)
# Average = 16 / 4 = 4
murray_lung_injury_score(80, 16, 18, 4)

# Example 2: Mild Injury
# PF 250 (1 pt), PEEP 8 (1 pt), Compliance 50 (2 pts), CXR 1 quad (1 pt)
# Average = 5 / 4 = 1.25
murray_lung_injury_score(250, 8, 50, 1)
}
