\name{mrecist_assessment}
\alias{mrecist_assessment}
\title{
Modified Response Evaluation Criteria in Solid Tumors (mRECIST) for HCC
}
\description{
Evaluates treatment response in Hepatocellular Carcinoma (HCC) using the mRECIST criteria. Unlike standard RECIST, mRECIST focuses on the viable (arterial enhancing) tumor burden rather than total tumor size, providing a better assessment of response to locoregional therapies.
}
\usage{
mrecist_assessment(target_lesions_sum_change, new_lesions_present,
                   nontarget_lesions_progression, arterial_enhancement_present)
}
\arguments{
  \item{target_lesions_sum_change}{
Numeric. Percentage change in the sum of diameters of viable (enhancing) target lesions compared to baseline (or nadir for progression). (e.g., -30 for 30\% decrease, +20 for 20\% increase).
}
  \item{new_lesions_present}{
Numeric (0 or 1). Appearance of new lesions? (1 = Yes).
}
  \item{nontarget_lesions_progression}{
Numeric (0 or 1). Unequivocal progression of non-target lesions? (1 = Yes).
}
  \item{arterial_enhancement_present}{
Numeric (0 or 1). Presence of intratumoral arterial enhancement in target lesions? (1 = Yes). Required to distinguish Complete Response from Partial Response.
}
}
\value{
A list containing:
\item{mRECIST_Response}{The calculated response category (CR, PR, SD, PD).}
\item{Description}{Explanation of the criteria met for the classification.}
}
\references{
Lencioni R, Llovet JM. Modified RECIST (mRECIST) assessment for hepatocellular carcinoma. Semin Liver Dis. 2010;30(1):52-60. doi:10.1055/s-0030-1247132
}
\examples{

# Example 1: Partial Response
# -40% change, no new lesions, enhancement still present
mrecist_assessment(-40, 0, 0, 1)

# Example 2: Progressive Disease (New Lesion)
# -10% change (stable target), but new lesion present
mrecist_assessment(-10, 1, 0, 1)
}
