\name{mg_adl_score}
\alias{mg_adl_score}
\title{
Myasthenia Gravis Activities of Daily Living (MG-ADL)
}
\description{
Calculates the MG-ADL score, an 8-item patient-reported scale assessing symptom severity and functional impact in Myasthenia Gravis. Each item is graded from 0 (normal) to 3 (severe), providing a total score ranging from 0 to 24. It correlates well with the Quantitative Myasthenia Gravis (QMG) score.
}
\usage{
mg_adl_score(talking, chewing, swallowing, breathing, tooth_brushing,
             combing_hair, standing_from_chair, double_vision, eyelid_droop)
}
\arguments{
  \item{talking}{
Numeric (0-3). 0: Normal. 1: Intermittent slurring/nasal speech. 2: Constant slurring/nasal, but understandable. 3: Difficult to understand speech.
}
  \item{chewing}{
Numeric (0-3). 0: Normal. 1: Fatigue with solid food. 2: Fatigue with soft food. 3: Gastric tube.
}
  \item{swallowing}{
Numeric (0-3). 0: Normal. 1: Fatigue with some foods. 2: Incomplete swallowing/choking. 3: Gastric tube.
}
  \item{breathing}{
Numeric (0-3). 0: Normal. 1: SOB with exertion. 2: SOB at rest. 3: Ventilator dependence.
}
  \item{tooth_brushing}{
Numeric (0-3). Impairment of ability to brush teeth or comb hair (Note: MDCalc often separates these or groups arms; standard MG-ADL groups "Brushing teeth or combing hair" as one item. If inputs differ, map to the most severe). 0: None. 1: Extra effort, no rest periods. 2: Rest periods needed. 3: Cannot do.
}
  \item{combing_hair}{
Numeric (0-3). See above. Usually combined with tooth brushing in the standard 8-item scale.
}
  \item{standing_from_chair}{
Numeric (0-3). Arising from a chair. 0: Normal. 1: Uses arms. 2: Uses arms, multiple attempts. 3: Needs assistance.
}
  \item{double_vision}{
Numeric (0-3). 0: None. 1: Occurs, but not daily. 2: Daily, but not constant. 3: Constant.
}
  \item{eyelid_droop}{
Numeric (0-3). 0: None. 1: Occurs, but not daily. 2: Daily, but not constant. 3: Constant.
}
}
\value{
A list containing:
\item{MG_ADL_Score}{The calculated total score (Range 0-24).}
\item{Interpretation}{Clinical context regarding score changes.}
}
\references{
Wolfe GI, Herbelin L, Nations SP, et al. Myasthenia gravis activities of daily living profile. Neurology. 1999;52(7):1487-1489. doi:10.1212/wnl.52.7.1487
}
\examples{

# Example 1: Moderate Disease
# Slurred speech (1), Fatigue chewing solids (1), Occasional diplopia (1), others 0
# Score = 3
mg_adl_score(1, 1, 0, 0, 0, 0, 0, 1, 0)

# Example 2: Severe Disease
# Choking (2), SOB at rest (2), Cannot brush teeth (3), Constant ptosis (3)
# Score = 10
mg_adl_score(0, 0, 2, 2, 3, 3, 0, 0, 3)
}
