\name{hits_screening_tool}
\alias{hits_screening_tool}
\title{
HITS (Hurt, Insult, Threaten, Scream) Screening Tool
}
\description{
Calculates the HITS score, a brief 4-item screening tool for domestic violence (Intimate Partner Violence). Each item measures the frequency of a specific abusive behavior on a scale from 1 to 5. A total score greater than 10 is generally considered a positive screen.
}
\usage{
hits_screening_tool(physically_hurt, insult, threaten_harm, scream_curse)
}
\arguments{
  \item{physically_hurt}{
Numeric (1-5). How often does your partner physically hurt you?
}
  \item{insult}{
Numeric (1-5). How often does your partner insult or talk down to you?
}
  \item{threaten_harm}{
Numeric (1-5). How often does your partner threaten you with harm?
}
  \item{scream_curse}{
Numeric (1-5). How often does your partner scream or curse at you?
}
}
\details{
\strong{Scoring Key:}
1 = Never
2 = Rarely
3 = Sometimes
4 = Fairly Often
5 = Frequently
}
\value{
A list containing:
\item{HITS_Score}{The calculated total score (Range 4-20).}
\item{Screening_Result}{"Positive Screen" if Score > 10, otherwise "Negative Screen".}
\item{Recommendation}{Clinical guidance based on the result.}
}
\references{
Sherin KM, Sinacore JM, Li XQ, Zitter RE, Shakil A. HITS: A short domestic violence screening tool for use in a family practice setting. Fam Med. 1998;30(7):508-512.
}
\examples{

# Example 1: Positive Screen
# Hurt(2), Insult(4), Threaten(2), Scream(4)
# Score = 12
hits_screening_tool(2, 4, 2, 4)

# Example 2: Negative Screen
# Never to all (1,1,1,1)
# Score = 4
hits_screening_tool(1, 1, 1, 1)
}
