\name{go_far_cardiac_arrest_score}
\alias{go_far_cardiac_arrest_score}
\title{
GO-FAR Score for In-Hospital Cardiac Arrest Outcome
}
\description{
Calculates the Good Outcome Following Attempted Resuscitation (GO-FAR) score to predict the likelihood of survival to discharge with good neurological outcome (CPC 1) after an in-hospital cardiac arrest (IHCA). The score uses pre-arrest variables available at admission or shortly before the event to stratify patients into risk categories.
}
\usage{
go_far_cardiac_arrest_score(age, neurologically_intact_admission, major_trauma,
                            acute_stroke, metastatic_hematologic_cancer, septicemia,
                            medical_noncardiac_diagnosis, hepatic_insufficiency,
                            skilled_nursing_facility, hypotension_hypoperfusion,
                            renal_insufficiency_dialysis, respiratory_insufficiency,
                            pneumonia)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<70: 0 pts.
70-74: +2 pts.
75-79: +5 pts.
80-84: +6 pts.
>=85: +11 pts.
}
  \item{neurologically_intact_admission}{
Numeric (0 or 1). Neurologically intact (CPC 1) or minimal deficits at admission. (1 = Yes, -15 pts).
}
  \item{major_trauma}{
Numeric (0 or 1). Major trauma during current admission. (1 = Yes, +10 pts).
}
  \item{acute_stroke}{
Numeric (0 or 1). Acute ischemic or hemorrhagic stroke during current admission. (1 = Yes, +8 pts).
}
  \item{metastatic_hematologic_cancer}{
Numeric (0 or 1). Metastatic or hematologic malignancy. (1 = Yes, +7 pts).
}
  \item{septicemia}{
Numeric (0 or 1). Septicemia. (1 = Yes, +7 pts).
}
  \item{medical_noncardiac_diagnosis}{
Numeric (0 or 1). Medical non-cardiac diagnosis on admission. (1 = Yes, +7 pts).
}
  \item{hepatic_insufficiency}{
Numeric (0 or 1). Hepatic insufficiency. (1 = Yes, +6 pts).
}
  \item{skilled_nursing_facility}{
Numeric (0 or 1). Admission from a skilled nursing facility (SNF). (1 = Yes, +6 pts).
}
  \item{hypotension_hypoperfusion}{
Numeric (0 or 1). Hypotension or hypoperfusion within 4 hours prior to arrest. (1 = Yes, +5 pts).
}
  \item{renal_insufficiency_dialysis}{
Numeric (0 or 1). Renal insufficiency or dialysis. (1 = Yes, +4 pts).
}
  \item{respiratory_insufficiency}{
Numeric (0 or 1). Respiratory insufficiency. (1 = Yes, +4 pts).
}
  \item{pneumonia}{
Numeric (0 or 1). Pneumonia. (1 = Yes, +1 pt).
}
}
\value{
A list containing:
\item{GO_FAR_Score}{The calculated score.}
\item{Probability_Neurologically_Intact_Survival}{Estimated probability of survival with good neurological outcome.}
\item{Risk_Group}{Classification (Very Low, Low, Average, Above Average).}
}
\references{
Ebell MH, Jang W, Shen Y, Geocadin RG. Development and validation of the Good Outcome Following Attempted Resuscitation (GO-FAR) score to predict neurologically intact survival after in-hospital cardiopulmonary resuscitation. JAMA Intern Med. 2013;173(20):1872-1878. doi:10.1001/jamainternmed.2013.10037
}
\examples{

# Example 1: Low Probability of Survival
# 85yo (+11), SNF (+6), Renal (+4), Neuro Intact (-15)
# Score = 11 + 6 + 4 - 15 = 6 (Average Probability? No wait, +6 is Average range -5 to 13)
# Let's check risk group: Score 6 -> Average Probability (3-15%)
go_far_cardiac_arrest_score(85, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0)

# Example 2: Very Low Probability
# 75yo (+5), Metastatic Cancer (+7), Sepsis (+7), Hypotension (+5), Not Neuro Intact (0)
# Score = 24
go_far_cardiac_arrest_score(75, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0)
}
