\name{geneva_vte_prophylaxis_score}
\alias{geneva_vte_prophylaxis_score}
\title{
Geneva Risk Score for VTE Prophylaxis
}
\description{
Calculates the Geneva Risk Score for Venous Thromboembolism (VTE) Prophylaxis in hospitalized medical patients. This score stratifies patients into low or high risk to guide the decision for pharmacologic thromboprophylaxis. Note: This is distinct from the "Geneva Score" used for diagnosing PE.
}
\usage{
geneva_vte_prophylaxis_score(heart_failure, respiratory_failure, recent_stroke,
                             recent_mi, acute_infection, rheumatic_disease,
                             active_malignancy, myeloproliferative_syndrome,
                             nephrotic_syndrome, prior_vte, hypercoagulable_state,
                             immobilization, recent_travel, age_gt_60,
                             obesity_bmi_gt_30, chronic_venous_insufficiency,
                             pregnancy, hormonal_therapy, dehydration)
}
\arguments{
  \item{heart_failure}{Numeric (0 or 1). Cardiac failure. (1 = Yes, +2 pts).}
  \item{respiratory_failure}{Numeric (0 or 1). Respiratory failure. (1 = Yes, +2 pts).}
  \item{recent_stroke}{Numeric (0 or 1). Recent stroke (<3 months ago). (1 = Yes, +2 pts).}
  \item{recent_mi}{Numeric (0 or 1). Recent myocardial infarction (<4 weeks ago). (1 = Yes, +2 pts).}
  \item{acute_infection}{Numeric (0 or 1). Acute infectious disease (including sepsis). (1 = Yes, +2 pts).}
  \item{rheumatic_disease}{Numeric (0 or 1). Acute rheumatic disease. (1 = Yes, +2 pts).}
  \item{active_malignancy}{Numeric (0 or 1). Active malignancy. (1 = Yes, +2 pts).}
  \item{myeloproliferative_syndrome}{Numeric (0 or 1). Myeloproliferative syndrome. (1 = Yes, +2 pts).}
  \item{nephrotic_syndrome}{Numeric (0 or 1). Nephrotic syndrome. (1 = Yes, +2 pts).}
  \item{prior_vte}{Numeric (0 or 1). Any prior VTE. (1 = Yes, +2 pts).}
  \item{hypercoagulable_state}{Numeric (0 or 1). Known hypercoagulable state. (1 = Yes, +2 pts).}
  \item{immobilization}{Numeric (0 or 1). Immobilization for >= 3 days (<30 min walking/day). (1 = Yes, +1 pt).}
  \item{recent_travel}{Numeric (0 or 1). Recent travel for > 6 hours. (1 = Yes, +1 pt).}
  \item{age_gt_60}{Numeric (0 or 1). Age > 60 years. (1 = Yes, +1 pt).}
  \item{obesity_bmi_gt_30}{Numeric (0 or 1). BMI > 30 kg/m2. (1 = Yes, +1 pt).}
  \item{chronic_venous_insufficiency}{Numeric (0 or 1). Chronic venous insufficiency. (1 = Yes, +1 pt).}
  \item{pregnancy}{Numeric (0 or 1). Pregnancy. (1 = Yes, +1 pt).}
  \item{hormonal_therapy}{Numeric (0 or 1). Hormonal therapy (contraceptive or replacement). (1 = Yes, +1 pt).}
  \item{dehydration}{Numeric (0 or 1). Dehydration. (1 = Yes, +1 pt).}
}
\value{
A list containing:
\item{Geneva_Prophylaxis_Score}{The calculated risk score.}
\item{Risk_Category}{"Low Risk" (Score < 3) or "High Risk" (Score >= 3).}
\item{Recommendation}{Clinical guidance regarding prophylaxis.}
}
\references{
Nendaz M, Spirk D, Kucher N, et al. Multicentre validation of the Geneva Risk Score for hospitalised medical patients at risk of venous thromboembolism. Thromb Haemost. 2014;111(3):531-538. doi:10.1160/TH13-05-0427
}
\examples{

# Example 1: High Risk
# 70yo (+1), Active Infection (+2)
# Score = 3
geneva_vte_prophylaxis_score(0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0)

# Example 2: Low Risk
# 50yo, Immobilized (+1), Obese (+1)
# Score = 2
geneva_vte_prophylaxis_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0)
}
