\name{fast_trauma_algorithm}
\alias{fast_trauma_algorithm}
\title{
Focused Assessment with Sonography for Trauma (FAST) Algorithm
}
\description{
Interprets the findings of the FAST exam in the context of the trauma patient's hemodynamic status. The FAST exam uses ultrasound to detect free fluid in the pericardial, perihepatic (RUQ), perisplenic (LUQ), and pelvic regions. The result guides immediate surgical or diagnostic decisions (Laparotomy vs. CT vs. Observation).
}
\usage{
fast_trauma_algorithm(pericardial_fluid, ruq_fluid, luq_fluid, pelvic_fluid,
                      patient_unstable)
}
\arguments{
  \item{pericardial_fluid}{
Numeric (0 or 1). Presence of fluid in the subxiphoid/pericardial view. (1 = Yes).
}
  \item{ruq_fluid}{
Numeric (0 or 1). Presence of fluid in the Right Upper Quadrant (Morison's Pouch). (1 = Yes).
}
  \item{luq_fluid}{
Numeric (0 or 1). Presence of fluid in the Left Upper Quadrant (Splenorenal Recess). (1 = Yes).
}
  \item{pelvic_fluid}{
Numeric (0 or 1). Presence of fluid in the Pelvic view (Retrovesical/Pouch of Douglas). (1 = Yes).
}
  \item{patient_unstable}{
Numeric (0 or 1). Is the patient hemodynamically unstable (e.g., Hypotension, Shock)? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{The overall interpretation of the FAST exam (Positive/Negative and location).}
\item{Management_Recommendation}{Clinical guidance based on ATLS protocols for the combination of FAST result and stability.}
}
\references{
Rozycki GS, Ochsner MG, Schmidt JA, et al. A prospective study of surgeon-performed ultrasound as the primary adjuvant modality for injured patient assessment. J Trauma. 1995;39(3):492-498.
}
\examples{

# Example 1: Unstable patient with fluid in RUQ
# Result: Positive FAST -> Laparotomy
fast_trauma_algorithm(0, 1, 0, 0, 1)

# Example 2: Stable patient with fluid in Pelvis
# Result: Positive FAST -> CT Scan
fast_trauma_algorithm(0, 0, 0, 1, 0)

# Example 3: Unstable patient with Negative FAST
# Result: Negative -> Search for other causes (Pelvic fx, etc.)
fast_trauma_algorithm(0, 0, 0, 0, 1)
}
