\name{dhaka_dehydration_score}
\alias{dhaka_dehydration_score}
\title{
DHAKA Score for Dehydration in Children
}
\description{
Calculates the Dehydration: Assessing Kids Accurately (DHAKA) score. This tool assesses the severity of dehydration in children (aged 1 month to 5 years) with acute diarrhea. It is validated for use in low-resource settings to guide rehydration therapy (ORS vs IV).
}
\usage{
dhaka_dehydration_score(general_appearance, sunken_eyes, dry_mucous_membranes,
                        tears_absent, skin_turgor, deep_breathing)
}
\arguments{
  \item{general_appearance}{
Numeric (0-2).
0: Alert/Normal.
1: Restless/Irritable.
2: Lethargic/Unconscious.
}
  \item{sunken_eyes}{
Numeric (0 or 1). Are the eyes sunken? (1 = Yes).
}
  \item{dry_mucous_membranes}{
Numeric (0 or 1). Are the mucous membranes (mouth/tongue) dry? (1 = Yes).
}
  \item{tears_absent}{
Numeric (0 or 1). Are tears absent when crying? (1 = Yes).
}
  \item{skin_turgor}{
Numeric (0-2). Skin pinch test (abdominal).
0: Immediate return (Normal).
1: Slow return (1-2 seconds).
2: Very slow return (> 2 seconds).
}
  \item{deep_breathing}{
Numeric (0 or 1). Presence of deep, acidotic breathing? (1 = Yes).
}
}
\value{
A list containing:
\item{DHAKA_Score}{The calculated score (Range 0-8).}
\item{Dehydration_Status}{Classification (No Dehydration, Some Dehydration, Severe Dehydration).}
\item{Management_Plan}{Recommended rehydration strategy (ORS or IV).}
}
\references{
Levine AC, Glavis-Bloom J, Modi P, et al. Derivation and internal validation of the DHAKA score for dehydration assessment in children with acute diarrhea in low-resource settings. Glob Health Sci Pract. 2013;1(1):97-108. doi:10.9745/GHSP-D-12-00012
Levine AC, Munyaneza RM, Glavis-Bloom J, et al. Prediction of severe dehydration in children with diarrhea/vomiting using the DHAKA score. Pediatrics. 2016.
}
\examples{

# Example 1: Severe Dehydration
# Lethargic (2), Sunken Eyes (1), Dry Mouth (1), No Tears (1),
#Very Slow Turgor (2), Deep Breathing (1)
# Score = 8
dhaka_dehydration_score(2, 1, 1, 1, 2, 1)

# Example 2: Some Dehydration
# Restless (1), Sunken Eyes (1), Normal Turgor (0), Tears Present (0)
# Score = 2
dhaka_dehydration_score(1, 1, 0, 0, 0, 0)
}
