\name{chalice_head_injury_rule}
\alias{chalice_head_injury_rule}
\title{
CHALICE Rule (Children's Head Injury Algorithm for the Prediction of Important Clinical Events)
}
\description{
Applies the CHALICE clinical decision rule to identify children with minor head injury who are at high risk for significant intracranial pathology and require a CT scan. The rule is considered positive if any one of the history, mechanism, or examination criteria is met.
}
\usage{
chalice_head_injury_rule(age_years, gcs_score, witnessed_loc_gt_5min,
                         amnesia_gt_5min, abnormal_drowsiness, vomiting_ge_3,
                         suspicion_nai, seizure, high_speed_mva, fall_gt_3m,
                         high_speed_object, open_depressed_fx_tense_fontanelle,
                         basal_skull_fx_signs, focal_neuro_deficit,
                         scalp_swelling_laceration_gt_5cm)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. (Used to adjust GCS threshold and swelling criteria).
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score. (Positive if < 14, or < 15 if age < 1 year).
}
  \item{witnessed_loc_gt_5min}{
Numeric (0 or 1). Witnessed Loss of Consciousness > 5 minutes. (1 = Yes).
}
  \item{amnesia_gt_5min}{
Numeric (0 or 1). History of amnesia > 5 minutes. (1 = Yes).
}
  \item{abnormal_drowsiness}{
Numeric (0 or 1). Abnormal drowsiness (drowsy, or only responding to voice/pain). (1 = Yes).
}
  \item{vomiting_ge_3}{
Numeric (0 or 1). >= 3 episodes of vomiting after injury. (1 = Yes).
}
  \item{suspicion_nai}{
Numeric (0 or 1). Suspicion of Non-Accidental Injury (Child Abuse). (1 = Yes).
}
  \item{seizure}{
Numeric (0 or 1). Seizure after injury (in patient without epilepsy). (1 = Yes).
}
  \item{high_speed_mva}{
Numeric (0 or 1). High-speed road traffic accident (> 40 mph / 64 kph) as pedestrian, cyclist, or occupant. (1 = Yes).
}
  \item{fall_gt_3m}{
Numeric (0 or 1). Fall from height > 3 meters. (1 = Yes).
}
  \item{high_speed_object}{
Numeric (0 or 1). High-speed injury from projectile or falling object. (1 = Yes).
}
  \item{open_depressed_fx_tense_fontanelle}{
Numeric (0 or 1). Suspicion of open or depressed skull fracture or tense fontanelle. (1 = Yes).
}
  \item{basal_skull_fx_signs}{
Numeric (0 or 1). Signs of basal skull fracture (Battle's sign, panda eyes, hemotympanum, CSF leak). (1 = Yes).
}
  \item{focal_neuro_deficit}{
Numeric (0 or 1). Focal neurological deficit. (1 = Yes).
}
  \item{scalp_swelling_laceration_gt_5cm}{
Numeric (0 or 1). Bruise, swelling, or laceration > 5cm on head. (1 = Yes). Note: Only triggers rule if age < 1 year.
}
}
\value{
A list containing:
\item{Recommendation}{"CT Head Indicated" or "CT Head Not Indicated".}
\item{Risk_Factors_Present}{List of specific criteria met that triggered the recommendation.}
}
\references{
Dunning J, Daly JP, Lomas JP, et al. Derivation of the children's head injury algorithm for the prediction of important clinical events decision rule for head injury in children. Arch Dis Child. 2006;91(11):885-891. doi:10.1136/adc.2005.083980
}
\examples{

# Example 1: High Risk Infant
# 6 months old, Swelling > 5cm
chalice_head_injury_rule(0.5, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1)

# Example 2: Low Risk Child
# 5 years old, GCS 15, minor fall, 1 vomit
chalice_head_injury_rule(5, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
