\name{barnes_jewish_dysphagia_screen}
\alias{barnes_jewish_dysphagia_screen}
\title{
Barnes-Jewish Hospital Stroke Dysphagia Screen
}
\description{
Implements the Barnes-Jewish Hospital Stroke Dysphagia Screen, a validated bedside tool to assess swallowing function in acute stroke patients. The screen consists of two stages: an initial assessment of consciousness and oral motor function, followed by a 3-oz water swallow test if the first stage is passed.
}
\usage{
barnes_jewish_dysphagia_screen(gcs, facial_asymmetry, tongue_asymmetry,
                               palatal_asymmetry, water_swallow_signs = NULL)
}
\arguments{
  \item{gcs}{
Numeric. Glasgow Coma Scale score (3-15). A score < 13 results in immediate failure.
}
  \item{facial_asymmetry}{
Numeric (0 or 1). Presence of facial asymmetry or weakness. (1 = Yes/Fail).
}
  \item{tongue_asymmetry}{
Numeric (0 or 1). Presence of tongue asymmetry or weakness. (1 = Yes/Fail).
}
  \item{palatal_asymmetry}{
Numeric (0 or 1). Presence of palatal asymmetry or weakness. (1 = Yes/Fail).
}
  \item{water_swallow_signs}{
Numeric (0 or 1) (Optional). Signs of aspiration (coughing, choking, wet voice) during or within 1 minute of the 3-oz water swallow test. (1 = Yes/Fail, 0 = No/Pass). Required only if the patient passes the initial anatomical assessment.
}
}
\value{
A list containing:
\item{Screen_Result}{"Passed", "Failed Bedside Assessment", or "Failed Water Swallow Test".}
\item{Action_Plan}{Clinical recommendation regarding diet status (NPO vs. oral intake) and Speech Therapy consult.}
\item{Fail_Criteria}{List of specific items that caused the screen failure.}
}
\references{
Edmiaston J, Connor LT, Loehr L, Nassief A. Validation of a dysphagia screening tool in acute stroke patients. Am J Crit Care. 2010;19(4):357-364. doi:10.4037/ajcc2009961
}
\examples{

# Example 1: Failed Initial Assessment
# GCS 15, but Facial Asymmetry present
barnes_jewish_dysphagia_screen(15, 1, 0, 0)

# Example 2: Passed Initial, Failed Water Test
# Normal anatomy, but coughed during water test
barnes_jewish_dysphagia_screen(15, 0, 0, 0, 1)

# Example 3: Passed Full Screen
# Normal anatomy, no signs on water swallow
barnes_jewish_dysphagia_screen(15, 0, 0, 0, 0)
}
