\name{atria_stroke_risk}
\alias{atria_stroke_risk}
\title{
ATRIA Stroke Risk Score
}
\description{
Calculates the ATRIA (Anticoagulation and Risk Factors in Atrial Fibrillation) Stroke Risk Score. This tool estimates the risk of ischemic stroke in patients with atrial fibrillation. It was developed to improve upon the CHADS2 score by incorporating differential weighting for age, prior stroke, and including renal dysfunction variables.
}
\usage{
atria_stroke_risk(age, prior_stroke, female_sex, diabetes, chf,
                  hypertension, proteinuria, egfr_lt_45_or_esrd)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<65: 0 points.
65-74: 3 points.
75-84: 5 points.
>=85: 6 points.
}
  \item{prior_stroke}{
Numeric (0 or 1). History of prior stroke. (1 = Yes, +4 points).
}
  \item{female_sex}{
Numeric (0 or 1). Patient is female. (1 = Yes, +1 point).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes mellitus. (1 = Yes, +1 point).
}
  \item{chf}{
Numeric (0 or 1). History of Congestive Heart Failure. (1 = Yes, +1 point).
}
  \item{hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes, +1 point).
}
  \item{proteinuria}{
Numeric (0 or 1). Presence of proteinuria. (1 = Yes, +1 point).
}
  \item{egfr_lt_45_or_esrd}{
Numeric (0 or 1). eGFR < 45 mL/min/1.73m^2 or End-Stage Renal Disease. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{ATRIA_Score}{The calculated risk score (Range 0-15).}
\item{Risk_Category}{Classification (Low 0-5, Moderate 6, High 7-15).}
\item{Annual_Stroke_Risk}{Estimated annual stroke rate.}
}
\references{
Singer DE, Chang Y, Borowsky LH, et al. A new risk scheme to predict ischemic stroke and other thromboembolism in atrial fibrillation: the ATRIA (Anticoagulation and Risk Factors in Atrial Fibrillation) Study. J Am Heart Assoc. 2013;2(3):e000250. doi:10.1161/JAHA.113.000250
}
\examples{

# Example 1: High Risk
# 85yo (+6), Female (+1), Prior Stroke (+4)
# Score = 11
atria_stroke_risk(85, 1, 1, 0, 0, 0, 0, 0)

# Example 2: Low Risk
# 70yo (+3), HTN (+1), No other factors
# Score = 4
atria_stroke_risk(70, 0, 0, 0, 0, 1, 0, 0)
}
