% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial_run.R
\docType{class}
\name{trial.estimates-class}
\alias{trial.estimates-class}
\title{trial.estimates class object}
\description{
\link[=Trial]{Trial$run()} returns an S3 class object
\code{trial.estimates}. The object contains all information to reproduce the
estimates as shown in the example.
The object is a list with the following components:
\describe{
\item{model}{\link{Trial} object used to generate the estimates.}
\item{estimates}{(list) Estimates of Monte-Carlo runs for each of the
estimators.}
\item{sample.data}{(data.table) Sample data returned from
\link[=Trial]{Trial$simulate()}.}
\item{estimators}{ (list) Estimators applied to simulated data in each
Monte-Carlo run.}
\item{sim.args}{ (list) Arguments passed on to \link[=Trial]{Trial$simulate()}
when simulating data in each Monte-Carlo run.}
\item{R}{ (numeric) Number of Monte-Carlo replications.}
}
}
\section{S3 generics}{

The following S3 generic functions are available for an object
of class \code{trial.estimates}:
\describe{
\item{\code{print}}{Basic print method.}
}
}

\examples{
trial <- Trial$new(
  covariates = function(n) data.frame(a = rbinom(n, 1, 0.5)),
  outcome = function(data) rnorm(nrow(data), data$a * -1)
 )
res <- trial$run(n = 100, R = 10, estimators = est_glm())
print(res)

# assuming previous estimates have been saved to disk.
# load estimates object and repeat simulation with more Monte-Carlo runs
res2 <- do.call(
  res$model$run,
  c(list(R = 20, estimators = res$estimators), res$sim.args)
)
print(res2)
}
