% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{optim_sa}
\alias{optim_sa}
\title{Root solver by Stochastic Approximation}
\usage{
optim_sa(
  f,
  init = 0,
  function.args = list(),
  ...,
  method = c("standard", "discrete", "interpolate"),
  projection = identity,
  control = list(niter = 100, alpha = 0.25, stepmult = 1),
  verbose = TRUE,
  burn.in = 0.75
)
}
\arguments{
\item{f}{Stochastic function}

\item{init}{Initial value to evaluate \code{f} in}

\item{function.args}{Additional arguments passed to \code{f}}

\item{...}{Additional arguments passed to \code{f}}

\item{method}{Method ('standard': standard Robbins-Monro, 'discrete' or
'interpolate' for integer stochastic optimization. See details section)}

\item{projection}{Optional projection function that can be used to constrain
the parameter value (e.g., function(x) max(x, tau)). Applied at the end of
each iteration of the optimization.}

\item{control}{Control arguments (\code{niter} number of iterations, \code{alpha} and
\code{stepmult} control the step-length of the Polyak-Ruppert algorithm as
described in the details section).}

\item{verbose}{if TRUE additional messages are printed throughout the
optimization}

\item{burn.in}{Burn-in (fraction of initial values to disregard) when
applying Polyak–Ruppert averaging (alpha<1). Alternatively, \code{burn.in}
can be given as an integer defining the absolut number of iterations to
disregard.}
}
\description{
Root solver by Stochastic Approximation
}
\details{
The aim is to find the root of the function \eqn{ M(\theta) = E
  f(\theta)}, where we are only able to observe the stochastic function
\eqn{f(\theta)}. We will assume that $M$ is non-decreasing with a unique
root \eqn{\theta^\ast}. The Robbins-Monro algorithm works through the
following update rule from an initial start value \eqn{\theta_0}:
\deqn{\theta_{n+1} = \theta_{n} - a_n f(\theta_n)} where
\eqn{\sum_{n=0}^\infty a_n = \infty} and \eqn{\sum_{n=0}^\infty a_n^2 <
  \infty}.

By averaging the iterates \deqn{\overline{\theta}_n =
\frac{1}{n}\sum_{i=1}^{n-1}\theta_i} we can get improved stability of the
algorithm that is less sensitive to the choice of the step-length \eqn{a_n}.
This is known as the Polyak-Ruppert algorithm and to ensure convergence
longer step sizes must be made which can be guaranteed by using \eqn{a_n =
Kn^{-\alpha}} with \eqn{0<\alpha<1}. The parameters \eqn{K} and \eqn{\alpha}
are controlled by the \code{stepmult} and \code{alpha} parameters of the
\code{control} argument.

For discrete problems where \eqn{\theta} must be an integer, we follow (Dupac
& Herkenrath, 1984). Let \eqn{\lfloor x\rfloor} denote the integer part of
\eqn{x}, and define either (method="discrete"): \deqn{g(\theta) =
I(U<\theta-\lfloor\theta\rfloor)f(\lfloor\theta\rfloor) +
I(U\geq\theta-\lfloor\theta\rfloor)f(\lfloor\theta\rfloor+1)} where
\eqn{U\sim Uniform([0,1])}, or (method="interpolate"): \deqn{g(\theta) =
(1-\theta+\lfloor\theta\rfloor)f(\lfloor\theta\rfloor) +
(\theta-\lfloor\theta\rfloor)f(\lfloor\theta\rfloor+1).} The stochastic
approximation method is then applied directly on \eqn{g}.

Dupač, V., & Herkenrath, U. (1984). On integer stochastic approximation.
Aplikace matematiky, 29(5), 372-383.
}
