% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneGrid_sdm.r
\name{tuneGrid_sdm}
\alias{tuneGrid_sdm}
\title{Retrieve tuneGrid from models}
\usage{
tuneGrid_sdm(i)
}
\arguments{
\item{i}{A \code{input_sdm} object containing models.}
}
\value{
A \code{list} with \code{data.frames} each one representing the table of a given model.
}
\description{
This function aims to retrieve the tune grid used to build models.
}
\examples{
# Create sdm_area object:
set.seed(1)
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random", n_set=2)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "boot",
                                number = 1,
                                repeats = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i, algo = c("naive_bayes"), ctrl=ctrl_sdm) |>
  suppressWarnings()

# Retrieve tuneGrid from model:
tuneGrid_sdm(i)

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
