% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_mudab.R
\name{mudab_plc_measurements}
\alias{mudab_plc_measurements}
\title{List MUDAB PLC measurement values}
\usage{
mudab_plc_measurements(
  filter = NULL,
  range = NULL,
  orderby = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{filter}{Optional filter definition.}

\item{range}{Optional range specification.}

\item{orderby}{Optional ordering specification.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with PLC measurements.
}
\description{
List MUDAB PLC measurement values
}
\details{
Returns PLC station measurement values.
Official docs: https://mudab.api.bund.dev.
}
\examples{
\dontrun{
mudab_plc_measurements(range = list(from = 0, count = 5))
}

}
