% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigmatrix-operations.R
\docType{methods}
\name{bigmatrix-operations}
\alias{bigmatrix-operations}
\alias{\%*\%,big.matrix,big.matrix-method}
\alias{\%*\%,matrix,big.matrix-method}
\alias{\%*\%,big.matrix,matrix-method}
\alias{Arith,big.matrix,big.matrix-method}
\alias{Arith,big.matrix,matrix-method}
\alias{Arith,matrix,big.matrix-method}
\alias{Arith,numeric,big.matrix-method}
\alias{Arith,big.matrix,numeric-method}
\title{Matrix and arithmetic operations for big.matrix objects}
\usage{
\S4method{\%*\%}{big.matrix,big.matrix}(x, y)

\S4method{\%*\%}{matrix,big.matrix}(x, y)

\S4method{\%*\%}{big.matrix,matrix}(x, y)

\S4method{Arith}{big.matrix,big.matrix}(e1, e2)

\S4method{Arith}{big.matrix,matrix}(e1, e2)

\S4method{Arith}{matrix,big.matrix}(e1, e2)

\S4method{Arith}{numeric,big.matrix}(e1, e2)

\S4method{Arith}{big.matrix,numeric}(e1, e2)
}
\arguments{
\item{x, y}{Matrix operands supplied either as \code{big.matrix} instances or
base R matrices, depending on the method signature.}

\item{e1, e2}{Numeric operands, which may be \code{big.matrix} objects, base
R matrices, or numeric scalars depending on the method signature.}
}
\description{
These methods extend the base matrix multiplication operator
(\code{\link[base]{\%*\%}}) and the group generic \code{\link[base]{Arithmetic}} so
that \code{\link[bigmemory]{big.matrix}} objects can interoperate with base
R matrices and numeric scalars using the high-performance routines provided
by \pkg{bigalgebra}.
}
\details{
Matrix multiplications dispatch to \code{bigalgebra::dgemm()}, mixed
arithmetic on matrices relies on \code{bigalgebra::daxpy()}, and
scalar/matrix combinations use \code{bigalgebra::dadd()} when appropriate.
}
\examples{
if (requireNamespace("bigmemory", quietly = TRUE) &&
    requireNamespace("bigalgebra", quietly = TRUE)) {
  x <- bigmemory::big.matrix(2, 2, init = 1)
  y <- bigmemory::big.matrix(2, 2, init = 2)
  x \%*\% y
  x + y
  x * 3
}

}
\seealso{
\code{\link[bigmemory:big.matrix]{bigmemory::big.matrix()}}, \code{\link[bigalgebra:dgemm]{bigalgebra::dgemm()}},
\code{\link[bigalgebra:daxpy]{bigalgebra::daxpy()}}, \code{\link[bigalgebra:dadd]{bigalgebra::dadd()}}
}
\keyword{methods}
