% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecb.R
\name{ecb_data}
\alias{ecb_data}
\title{Fetch European Central Bank (ECB) data}
\source{
\url{https://data.ecb.europa.eu/help/api/data}
}
\usage{
ecb_data(
  flow,
  key = NULL,
  start_period = NULL,
  end_period = NULL,
  first_n = NULL,
  last_n = NULL
)
}
\arguments{
\item{flow}{(\code{character(1)})\cr
Flow to query.}

\item{key}{(\code{character()})\cr
The series keys to query.}

\item{start_period}{(\code{NULL} | \code{character(1)} | \code{integer(1)})\cr
Start date of the data. Supported formats:
\itemize{
\item YYYY for annual data (e.g., \code{2019})
\item YYYY-S[1-2] for semi-annual data (e.g., \code{"2019-S1"})
\item YYYY-Q[1-4] for quarterly data (e.g., \code{"2019-Q1"})
\item YYYY-MM for monthly data (e.g., \code{"2019-01"})
\item YYYY-W[01-53] for weekly data (e.g., \code{"2019-W01"})
\item YYYY-MM-DD for daily and business data (e.g., \code{"2019-01-01"})
}

If \code{NULL}, no start date restriction is applied (data retrieved from the earliest available
date). Default \code{NULL}.}

\item{end_period}{(\code{NULL} | \code{character(1)} | \code{integer(1)})\cr
End date of the data, in the same format as start_period. If \code{NULL}, no end date restriction is
applied (data retrieved up to the most recent available date). Default \code{NULL}.}

\item{first_n}{(\code{NULL} | \code{numeric(1)})\cr
Number of observations to retrieve from the start of the series. If \code{NULL}, no restriction is
applied. Default \code{NULL}.}

\item{last_n}{(\code{NULL} | \code{numeric(1)})\cr
Number of observations to retrieve from the end of the series. If \code{NULL}, no restriction is
applied. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the ECB SDMX Web Service.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# fetch US dollar/Euro exchange rate
ecb_data("EXR", "D.USD.EUR.SP00.A")

# fetch data for multiple keys
ecb_data("EXR", c("D.USD", "JPY.EUR.SP00.A"))
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{boe_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
