% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gamma_regression.R
\name{fit_gamma_regression}
\alias{fit_gamma_regression}
\title{Function for Fitting the Mean-Variance Gamma Regression Models}
\usage{
fit_gamma_regression(data, formula = sd ~ mean, ...)
}
\arguments{
\item{data}{a \code{data.frame} to generate the mean-variance trends for. It
should contain columns with conditions named as the column names in
\code{design} (presumably with some suffix).}

\item{formula}{a formula describing the model}

\item{...}{only for compatibility with other functions}
}
\value{
\code{fit_gamma_regression} returns a glm object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{fit_gamma_regression} returns a \code{glm} object containing the
gamma regression for the mean-variance trend.
}
\examples{
# Generate a design matrix for the data
design <- model.matrix(~ 0 + factor(rep(1:2, each = 3)))

# Set correct colnames, this is important for calculate_mean_sd_trends
colnames(design) <- paste0("ng", c(50, 100))

# Normalize and log-transform the data
yeast_norm <- psrn(yeast, "identifier") \%>\%
  # Add row means and variances
  calculate_mean_sd_trends(design)

# Fit gamma regression model for the mean-variance trends
gamma_model <- fit_gamma_regression(yeast_norm, sd ~ mean)
}
