% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-azure-cli.R
\name{az_cli_get_token}
\alias{az_cli_get_token}
\title{Get Access Token from Azure CLI}
\usage{
az_cli_get_token(scope, tenant_id = NULL, timeout = 10L)
}
\arguments{
\item{scope}{A character string specifying the OAuth2 scope for which to
request the access token (e.g., \code{"https://management.azure.com/.default"}).}

\item{tenant_id}{A character string specifying the Azure Active Directory
tenant ID. If \code{NULL}, uses the default tenant from Azure CLI. Defaults to \code{NULL}.}

\item{timeout}{A numeric value specifying the timeout in seconds for the
Azure CLI process. Defaults to \code{10}.}
}
\value{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing:
\itemize{
\item \code{access_token}: The OAuth2 access token string
\item \code{token_type}: The type of token (typically "Bearer")
\item \code{.expires_at}: POSIXct timestamp when the token expires
}
}
\description{
Retrieves an access token from Azure CLI using the \verb{az account get-access-token}
command. This is a lower-level function that directly interacts with the Azure
CLI to obtain OAuth2 tokens.
}
\details{
This function executes the Azure CLI command and parses the JSON response to
create an httr2 OAuth token object. The token includes the access token,
token type, and expiration time.
}
\examples{
\dontrun{
# Get a token for Azure Resource Manager
token <- az_cli_get_token(
  scope = "https://management.azure.com/.default"
)

# Get a token for a specific tenant
token <- az_cli_get_token(
  scope = "https://graph.microsoft.com/.default",
  tenant_id = "your-tenant-id"
)

# Access the token string
access_token <- token$access_token
}

}
