### Returns the minimum and maximum Ansari-Bradley test statistic by
### enumerating all possible ranks.
### Computational costs: N!/(n+m-n_prime-m_prime)!
EnumeratingAnsairiBradley <- function(X,Y){
  n <- length(X)
  m <- length(Y)
  N <- n + m
  AllRanks <- 1:N

  ObsX <- X[!is.na(X)]
  n_prime <- length(ObsX)

  ObsY <- Y[!is.na(Y)]
  m_prime <- length(ObsY)

  PartialRankX <- rank(c(ObsX,ObsY))[1:n_prime]  ### ranks of samples in observed X among all observed samples

  if(n_prime + m_prime == N){
    ## No missing data in X and Y
    return(rep(AnsariBradley(PartialRankX,N),2))
  }

  ### All possible permutations of ranks of missing samples
  AllPossibleMissingRanks <- gtools::permutations(N, (N - n_prime - m_prime))

  Res <- 0 ## initialize results

  if(n_prime < n){
    ## X is not fully observed
    for (i in 1:dim(AllPossibleMissingRanks)[1]) {
      RanksMissingX <- AllPossibleMissingRanks[i,(1:(n-n_prime))]
      ReminingRanks <- setdiff(AllRanks, AllPossibleMissingRanks[i,])
      Res[i] <- AnsariBradley(c(RanksMissingX,ReminingRanks[PartialRankX]),N)
    }
  }else{
    ## X is fully observed, hence Y must contains missing data
    for (i in 1:dim(AllPossibleMissingRanks)[1]) {
      ReminingRanks <- setdiff(AllRanks, AllPossibleMissingRanks[i,])
      Res[i] <- AnsariBradley(ReminingRanks[PartialRankX],N)
    }

  }
  return(c(min(Res), max(Res)))
}
